/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.FilterFourPoles;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.WhiteNoise;
import com.jsyn.util.WaveRecorder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JApplet;

public class RecordMoogFilter
extends JApplet {
    private static final boolean SWEEP_Q = false;
    private static final boolean SWEEP_FREQUENCY = true;
    private static final int NUM_STEPS = 11;
    private static final double MIN_Q = 0.0;
    private static final double DEFAULT_Q = 9.0;
    private static final double MAX_Q = 10.0;
    private static final double MIN_FREQUENCY = 100.0;
    private static final double DEFAULT_FREQUENCY = 500.0;
    private static final double MAX_FREQUENCY = 4000.0;
    private Synthesizer synth;
    private WhiteNoise source;
    private SineOscillator reference;
    private FilterFourPoles filterMoog;
    private LineOut lineOut;
    private WaveRecorder recorder;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        this.source = new WhiteNoise();
        this.synth.add(this.source);
        this.filterMoog = new FilterFourPoles();
        this.synth.add(this.filterMoog);
        this.reference = new SineOscillator();
        this.synth.add(this.reference);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.source.output.connect(this.filterMoog.input);
        this.reference.output.connect(0, this.lineOut.input, 0);
        this.filterMoog.output.connect(0, this.lineOut.input, 1);
        this.reference.amplitude.set(0.5);
        this.source.amplitude.set(0.5);
        this.filterMoog.frequency.set(500.0);
        this.filterMoog.Q.set(9.0);
        File waveFile = new File("temp_recording.wav");
        try {
            this.recorder = new WaveRecorder(this.synth, waveFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("Writing to WAV file " + waveFile.getAbsolutePath());
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
        this.reference.output.connect(0, this.recorder.getInput(), 0);
        this.filterMoog.output.connect(0, this.recorder.getInput(), 1);
        this.recorder.start();
    }

    @Override
    public void stop() {
        if (this.recorder != null) {
            this.recorder.stop();
            try {
                this.recorder.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.lineOut.stop();
        this.synth.stop();
    }

    public void test() {
        this.init();
        this.start();
        try {
            this.calibrate();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.stop();
    }

    private void calibrate() throws InterruptedException {
        this.synth.sleepFor(0.2);
        double freq = 100.0;
        double q = 9.0;
        double stepQ = 1.0;
        double scaleFrequency = Math.pow(40.0, 0.1);
        System.out.printf("freq, q, measured\n", new Object[0]);
        int i = 0;
        while (i < 11) {
            double refAmp = this.reference.amplitude.get();
            this.reference.amplitude.set(0.0);
            this.synth.sleepFor(0.1);
            this.reference.amplitude.set(refAmp);
            System.out.printf("%8.2f, %6.3f, \n", freq, q);
            this.filterMoog.frequency.set(freq);
            this.reference.frequency.set(freq);
            this.filterMoog.Q.set(q);
            this.synth.sleepFor(2.0);
            freq *= scaleFrequency;
            ++i;
        }
    }

    public static void main(String[] args) {
        new RecordMoogFilter().test();
    }
}

