/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class AsymptoticRamp
extends UnitFilter {
    public UnitVariablePort current;
    public UnitInputPort halfLife = new UnitInputPort(1, "HalfLife", 0.1);
    private double previousHalfLife = -1.0;
    private double decayScalar = 0.99;

    public AsymptoticRamp() {
        this.addPort(this.halfLife);
        this.current = new UnitVariablePort("Current");
        this.addPort(this.current);
    }

    @Override
    public void generate(int start, int limit) {
        double currentValue;
        double[] outputs = this.output.getValues();
        double[] inputs = this.input.getValues();
        double currentHalfLife = this.halfLife.getValues()[0];
        double inputValue = currentValue = this.current.getValue();
        if (currentHalfLife != this.previousHalfLife) {
            this.decayScalar = this.convertHalfLifeToMultiplier(currentHalfLife);
            this.previousHalfLife = currentHalfLife;
        }
        int i = start;
        while (i < limit) {
            inputValue = inputs[i];
            currentValue += this.decayScalar * (inputValue - currentValue);
            outputs[i] = currentValue;
            ++i;
        }
        if (Math.abs(inputValue - currentValue) < 1.0E-26) {
            currentValue = inputValue;
        }
        this.current.setValue(currentValue);
    }
}

