/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitGenerator;
import java.io.PrintStream;

public class InputMixingBlockPart
extends PortBlockPart {
    private double[] mixer = new double[8];
    private double current;
    private UnitInputPort unitInputPort;

    InputMixingBlockPart(UnitInputPort unitInputPort, double defaultValue) {
        super(unitInputPort, defaultValue);
        this.unitInputPort = unitInputPort;
    }

    @Override
    public double getValue() {
        return this.current;
    }

    @Override
    protected void setValue(double value) {
        this.current = value;
        super.setValue(value);
    }

    @Override
    public double[] getValues() {
        double[] result;
        int numConnections = this.getConnectionCount();
        if (numConnections == 0) {
            result = super.getValues();
        } else {
            PortBlockPart otherPart;
            double[] inputs;
            int jCon = 0;
            if (this.unitInputPort.isValueAdded()) {
                inputs = super.getValues();
                jCon = 0;
            } else {
                otherPart = this.getConnection(jCon);
                inputs = otherPart.getValues();
                jCon = 1;
            }
            int i = 0;
            while (i < this.mixer.length) {
                this.mixer[i] = inputs[i];
                ++i;
            }
            while (jCon < numConnections) {
                otherPart = this.getConnection(jCon);
                inputs = otherPart.getValues();
                i = 0;
                while (i < this.mixer.length) {
                    int n = i;
                    this.mixer[n] = this.mixer[n] + inputs[i];
                    ++i;
                }
                ++jCon;
            }
            result = this.mixer;
        }
        this.current = result[0];
        return result;
    }

    private void printIndentation(PrintStream out, int level) {
        int i = 0;
        while (i < level) {
            out.print("    ");
            ++i;
        }
    }

    private String portToString(UnitBlockPort port) {
        UnitGenerator ugen = port.getUnitGenerator();
        return String.valueOf(ugen.getClass().getSimpleName()) + "." + port.getName();
    }

    public void printConnections(PrintStream out, int level) {
        int i = 0;
        while (i < this.getConnectionCount()) {
            PortBlockPart part = this.getConnection(i);
            this.printIndentation(out, level);
            out.println(String.valueOf(this.portToString(this.getPort())) + " <--- " + this.portToString(part.getPort()));
            part.getPort().getUnitGenerator().printConnections(out, level + 1);
            ++i;
        }
    }
}

