/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.scope.AudioScope;
import com.jsyn.scope.AudioScopeProbe;
import com.jsyn.swing.DoubleBoundedRangeSlider;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.unitgen.ImpulseOscillator;
import com.jsyn.unitgen.ImpulseOscillatorBL;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.MorphingOscillatorBL;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PulseOscillator;
import com.jsyn.unitgen.PulseOscillatorBL;
import com.jsyn.unitgen.RedNoise;
import com.jsyn.unitgen.SawtoothOscillator;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SawtoothOscillatorDPW;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SquareOscillator;
import com.jsyn.unitgen.SquareOscillatorBL;
import com.jsyn.unitgen.TriangleOscillator;
import com.jsyn.unitgen.UnitOscillator;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SeeOscillators
extends JApplet {
    private static final long serialVersionUID = -8315903842197137926L;
    private Synthesizer synth;
    private ArrayList<UnitOscillator> oscillators = new ArrayList();
    private LineOut lineOut;
    private AudioScope scope;
    private JPanel oscPanel;
    private Multiply oscGain;
    private ButtonGroup buttonGroup;
    private LinearRamp freqRamp;
    private LinearRamp widthRamp;
    private LinearRamp shapeRamp;
    private DoubleBoundedRangeSlider widthSlider;
    private DoubleBoundedRangeSlider shapeSlider;

    public static void main(String[] args) {
        SeeOscillators applet = new SeeOscillators();
        JAppletFrame frame = new JAppletFrame("ShowWaves", applet);
        frame.setSize(640, 500);
        frame.setVisible(true);
        frame.test();
        frame.validate();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add("North", new JLabel("Show Oscillators in an AudioScope"));
        this.scope = new AudioScope(this.synth);
        AudioScopeProbe probe = this.scope.addProbe(this.oscGain.output);
        probe.setAutoScaleEnabled(false);
        probe.setVerticalScale(1.1);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setControlsVisible(false);
        this.scope.start();
        this.add("Center", this.scope.getView());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(0, 1));
        this.add("South", southPanel);
        this.oscPanel = new JPanel();
        this.oscPanel.setLayout(new GridLayout(2, 5));
        southPanel.add(this.oscPanel);
        southPanel.add(PortControllerFactory.createExponentialPortSlider(this.freqRamp.input));
        southPanel.add(PortControllerFactory.createExponentialPortSlider(this.oscGain.inputB));
        this.widthSlider = PortControllerFactory.createPortSlider(this.widthRamp.input);
        southPanel.add(this.widthSlider);
        this.widthSlider.setEnabled(false);
        this.shapeSlider = PortControllerFactory.createPortSlider(this.shapeRamp.input);
        southPanel.add(this.shapeSlider);
        this.shapeSlider.setEnabled(false);
        this.oscPanel.validate();
        this.validate();
    }

    @Override
    public void start() {
        this.synth = JSyn.createSynthesizer();
        this.oscGain = new Multiply();
        this.synth.add(this.oscGain);
        this.oscGain.inputB.setup(0.02, 0.5, 1.0);
        this.oscGain.inputB.setName("Amplitude");
        this.freqRamp = new LinearRamp();
        this.synth.add(this.freqRamp);
        this.freqRamp.input.setup(50.0, 300.0, 20000.0);
        this.freqRamp.input.setName("Frequency");
        this.freqRamp.time.set(0.1);
        this.widthRamp = new LinearRamp();
        this.synth.add(this.widthRamp);
        this.widthRamp.input.setup(-1.0, 0.0, 1.0);
        this.widthRamp.input.setName("Width");
        this.widthRamp.time.set(0.1);
        this.shapeRamp = new LinearRamp();
        this.synth.add(this.shapeRamp);
        this.shapeRamp.input.setup(-1.0, 0.0, 1.0);
        this.shapeRamp.input.setName("Shape");
        this.shapeRamp.time.set(0.1);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.oscGain.output.connect(0, this.lineOut.input, 0);
        this.oscGain.output.connect(0, this.lineOut.input, 1);
        this.setupGUI();
        this.buttonGroup = new ButtonGroup();
        this.addOscillator(new SineOscillator(), "Sine");
        this.addOscillator(new TriangleOscillator(), "Triangle");
        this.addOscillator(new SawtoothOscillator(), "Sawtooth");
        this.addOscillator(new SawtoothOscillatorBL(), "SawBL");
        this.addOscillator(new SawtoothOscillatorDPW(), "SawDPW");
        this.addOscillator(new RedNoise(), "RedNoise");
        this.addOscillator(new SquareOscillator(), "Square");
        this.addOscillator(new SquareOscillatorBL(), "SquareBL");
        this.addOscillator(new PulseOscillator(), "Pulse");
        this.addOscillator(new PulseOscillatorBL(), "PulseBL");
        this.addOscillator(new MorphingOscillatorBL(), "MorphBL");
        this.addOscillator(new ImpulseOscillator(), "Impulse");
        this.addOscillator(new ImpulseOscillatorBL(), "ImpulseBL");
        this.synth.start();
        this.lineOut.start();
        this.lineOut.start();
    }

    private void addOscillator(final UnitOscillator osc, String label) {
        this.oscillators.add(osc);
        this.synth.add(osc);
        this.freqRamp.output.connect(osc.frequency);
        if (osc instanceof PulseOscillatorBL) {
            this.widthRamp.output.connect(((PulseOscillatorBL)osc).width);
        }
        if (osc instanceof PulseOscillator) {
            this.widthRamp.output.connect(((PulseOscillator)osc).width);
        }
        if (osc instanceof MorphingOscillatorBL) {
            this.shapeRamp.output.connect(((MorphingOscillatorBL)osc).shape);
        }
        osc.amplitude.set(1.0);
        JRadioButton checkBox = new JRadioButton(label);
        this.buttonGroup.add(checkBox);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((SeeOscillators)SeeOscillators.this).oscGain.inputA.disconnectAll(0);
                osc.output.connect(((SeeOscillators)SeeOscillators.this).oscGain.inputA);
                SeeOscillators.this.widthSlider.setEnabled(osc instanceof PulseOscillator || osc instanceof PulseOscillatorBL);
                SeeOscillators.this.shapeSlider.setEnabled(osc instanceof MorphingOscillatorBL);
            }
        });
        this.oscPanel.add(checkBox);
    }

    @Override
    public void stop() {
        this.scope.stop();
        this.synth.stop();
    }
}

