/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.devices.AudioDeviceOutputStream;
import com.jsyn.devices.javasound.JavaSoundAudioDevice;
import com.jsyn.engine.SynthesisEngine;
import java.io.IOException;
import junit.framework.TestCase;

public class TestAudioOutput
extends TestCase {
    SynthesisEngine synthesisEngine;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMonoSine() throws IOException {
        System.out.println("Test mono output.");
        int FRAMES_PER_BUFFER = 128;
        boolean SAMPLES_PER_FRAME = true;
        double[] buffer = new double[128];
        JavaSoundAudioDevice audioDevice = new JavaSoundAudioDevice();
        AudioDeviceOutputStream audioOutput = audioDevice.createOutputStream(audioDevice.getDefaultOutputDeviceID(), 44100, 1);
        int i = 0;
        while (i < 128) {
            double angle = (double)i * Math.PI * 2.0 / 128.0;
            buffer[i] = Math.sin(angle);
            ++i;
        }
        audioOutput.start();
        i = 0;
        while (i < 1000) {
            audioOutput.write(buffer);
            ++i;
        }
        audioOutput.stop();
    }

    public void testStereoSine() throws IOException {
        System.out.println("Test stereo output.");
        int FRAMES_PER_BUFFER = 128;
        int SAMPLES_PER_FRAME = 2;
        double[] buffer = new double[256];
        JavaSoundAudioDevice audioDevice = new JavaSoundAudioDevice();
        AudioDeviceOutputStream audioOutput = audioDevice.createOutputStream(audioDevice.getDefaultOutputDeviceID(), 44100, 2);
        int bi = 0;
        int i = 0;
        while (i < 128) {
            double angle = (double)i * Math.PI * 2.0 / 128.0;
            buffer[bi++] = Math.sin(angle);
            buffer[bi++] = Math.sin(angle);
            ++i;
        }
        audioOutput.start();
        i = 0;
        while (i < 1000) {
            audioOutput.write(buffer);
            ++i;
        }
        audioOutput.stop();
    }
}

