/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.model.core.OnOffModule;
import com.syntona.model.core.PlayKeyModulePresenter;

public class PitchKeyModulePresenter
extends PlayKeyModulePresenter {
    private static final int LOW_C = 36;
    static String keyboard = "ZXCVBNMASDFGHJQWERTYU12345678";

    public PitchKeyModulePresenter() {
        super(new OnOffModule("Send pitch to \"on\" or \"off\" jack."));
    }

    private int convertIndexToPitch(int index) {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] scale = nArray;
        int octave = index / scale.length;
        int idx = index % scale.length;
        return octave * 12 + scale[idx] + 36;
    }

    @Override
    public void keyOn(char key) {
        int index = keyboard.indexOf(key);
        if (index >= 0) {
            int pitch = this.convertIndexToPitch(index);
            this.sendOnMessage(pitch);
        }
    }

    @Override
    public void keyOff(char key) {
        int index = keyboard.indexOf(key);
        if (index >= 0) {
            int pitch = this.convertIndexToPitch(index);
            this.sendOffMessage(pitch);
        }
    }
}

