/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitOutputPort;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.jsyn.AudioJack;
import com.syntona.model.jsyn.InputAudioJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.SyntonaModule;
import java.awt.Color;

public class OutputAudioJack
extends OutputJack
implements AudioJack {
    private UnitOutputPort port;
    private int partIndex;
    private static Color SIGNAL_COLOR = new Color(0, 200, 0);
    private static Color JACK_COLOR = new Color(200, 255, 200);

    public OutputAudioJack(SyntonaModule module, String name, String help) {
        super(module, name, help);
    }

    public OutputAudioJack(SyntonaModule module, String fieldName, UnitOutputPort port) {
        this(module, fieldName, "generic JSyn jack");
        this.port = port;
    }

    @Override
    public Color getColor() {
        return JACK_COLOR;
    }

    @Override
    public Color getSignalColor() {
        return SIGNAL_COLOR;
    }

    @Override
    public void setPartIndex(int j) {
        this.partIndex = j;
    }

    @Override
    public int getPartIndex() {
        return this.partIndex;
    }

    @Override
    public UnitOutputPort getSynthPort() {
        return this.port;
    }

    public void setSynthPort(UnitOutputPort synthPort) {
        this.port = synthPort;
    }

    @Override
    public boolean willAccept(Jack other) {
        if (other instanceof AudioJack) {
            return super.willAccept(other);
        }
        return false;
    }

    @Override
    public String getValueText() {
        return "" + this.port.get(this.partIndex);
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 4: {
                int i = 0;
                while (i < this.getConnectedCount()) {
                    Jack otherJack = this.getConnected(i);
                    InputAudioJack otherAudioJack = (InputAudioJack)otherJack;
                    SyntonaModule otherModule = otherJack.getModule();
                    if (otherModule.isExportable()) {
                        String thisName = InputAudioJack.getExportablePortName(this.port);
                        String otherName = otherAudioJack.getExportablePortName();
                        if (this.getPartIndex() == 0 && otherAudioJack.getPartIndex() == 0) {
                            writer.println(String.valueOf(this.getModule().getExportedObjectName()) + "." + thisName + ".connect(" + otherJack.getModule().getExportedObjectName() + "." + otherName + ");");
                        } else {
                            writer.println(String.valueOf(this.getModule().getExportedObjectName()) + "." + thisName + ".connect(" + this.getPartIndex() + ", " + otherJack.getModule().getExportedObjectName() + "." + otherName + ", " + otherAudioJack.getPartIndex() + ");");
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public String getPortName() {
        return this.port.getName();
    }
}

