/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.jsyn.AudioJack;
import com.syntona.model.jsyn.InputAudioJackEditor;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaModule;
import java.awt.Color;
import java.lang.reflect.Field;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;

public class InputAudioJack
extends InputDoubleJack
implements AudioJack {
    private static final String NAME_VALUE_ADDED = "valueAdded";
    private UnitInputPort mPort;
    private int mPartIndex;
    private static Color JACK_COLOR = new Color(200, 255, 200);

    private static boolean isNameExponential(String name) {
        return name.startsWith("gain") || name.startsWith("amplitude") || name.startsWith("frequency") || name.startsWith("time") || name.startsWith("delay") || name.startsWith("attack") || name.startsWith("hold") || name.startsWith("decay") || name.startsWith("release");
    }

    public InputAudioJack(SyntonaModule syntonaModule, String fieldName, UnitInputPort port, int partIndex) {
        super(syntonaModule, fieldName, InputAudioJack.isNameExponential(fieldName));
        this.setHelp("generic JSyn port");
        this.mPort = port;
        this.mPartIndex = partIndex;
        this.setMin(port.getMinimum());
        this.setMax(port.getMaximum());
        this.setValue(port.getValue());
        this.getDoubleRangeModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InputAudioJack.this.mPort.set(InputAudioJack.this.mPartIndex, InputAudioJack.this.getDoubleRangeModel().getValue());
            }
        });
    }

    @Override
    public Color getColor() {
        return JACK_COLOR;
    }

    @Override
    public UnitPort getSynthPort() {
        return this.mPort;
    }

    public void setUnitInputPort(UnitInputPort port) {
        this.mPort = port;
    }

    public UnitInputPort getUnitInputPort() {
        return this.mPort;
    }

    @Override
    public void setPartIndex(int j) {
        this.mPartIndex = j;
        super.setValue(this.mPort.getValue(j));
    }

    @Override
    public int getPartIndex() {
        return this.mPartIndex;
    }

    @Override
    public String getValueText() {
        return "" + this.mPort.getValue(this.mPartIndex);
    }

    @Override
    public void removeConnection(Jack other) {
        super.removeConnection(other);
        if (other instanceof OutputAudioJack) {
            OutputAudioJack otherAudioJack = (OutputAudioJack)other;
            UnitOutputPort otherUnitBlockPort = otherAudioJack.getSynthPort();
            otherUnitBlockPort.disconnect(otherAudioJack.getPartIndex(), (UnitInputPort)this.getSynthPort(), this.mPartIndex);
        }
    }

    @Override
    public void addConnection(Jack other) {
        super.addConnection(other);
        if (other instanceof AudioJack) {
            AudioJack source = (AudioJack)((Object)other);
            UnitInputPort thisInput = this.mPort;
            if (source.getSynthPort() instanceof UnitOutputPort) {
                ((UnitOutputPort)source.getSynthPort()).connect(source.getPartIndex(), thisInput, this.getPartIndex());
            } else {
                throw new RuntimeException("Cannot connect these together. UNIMPLEMENTED");
            }
        }
    }

    @Override
    public double getValue() {
        return this.mPort.get(this.mPartIndex);
    }

    @Override
    public void setValue(double d) {
        this.mPort.set(this.mPartIndex, d);
        super.setValue(d);
    }

    @Override
    public void setMin(double min) {
        this.mPort.setMinimum(min);
        super.setMin(min);
    }

    @Override
    public void setMax(double max) {
        this.mPort.setMaximum(max);
        super.setMax(max);
    }

    public void setValueAdded(boolean flag) {
        this.mPort.setValueAdded(flag);
    }

    public boolean isValueAdded() {
        return this.mPort.isValueAdded();
    }

    @Override
    public void saveAttributes(SyntonaSaver saver) {
        super.saveAttributes(saver);
        saver.addAttribute(NAME_VALUE_ADDED, "" + this.isValueAdded());
    }

    @Override
    public void loadContents(Element jackElement) {
        super.loadContents(jackElement);
        this.setValueAdded(XMLDOMLoader.parseBooleanAttribute(jackElement, NAME_VALUE_ADDED));
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        switch (phase) {
            case 5: {
                boolean isConnected = this.mPort.isConnected(this.mPartIndex);
                IndentingWriter writer = exporter.getWriter();
                String thisName = this.getExportablePortName();
                if (!isConnected) {
                    if (this.mPartIndex == 0) {
                        writer.println(String.valueOf(this.getModule().getExportedObjectName()) + "." + thisName + ".set(" + this.mPort.getValue(this.mPartIndex) + ");");
                    } else {
                        writer.println(String.valueOf(this.getModule().getExportedObjectName()) + "." + thisName + ".set(" + this.mPartIndex + ", " + this.mPort.getValue(this.mPartIndex) + ");");
                    }
                }
                if (!this.mPort.isValueAdded()) break;
                writer.println(String.valueOf(this.getModule().getExportedObjectName()) + "." + thisName + ".setValueAdded(true);");
            }
        }
    }

    String getExportablePortName() {
        return InputAudioJack.getExportablePortName(this.mPort);
    }

    public static String getExportablePortName(UnitPort port) {
        Field[] fields;
        String name = port.getName();
        UnitGenerator unit = port.getUnitGenerator();
        Field[] fieldArray = fields = unit.getClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                UnitPort somePort;
                Object unitField = field.get(unit);
                if (unitField != null && unitField instanceof UnitPort && (somePort = (UnitPort)unitField) == port) {
                    name = field.getName();
                    break;
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return name;
    }

    String getPortName() {
        return this.mPort.getName();
    }

    @Override
    public JackEditor getEditor(ModulePresenter modulePresenter) {
        return new InputAudioJackEditor(this, modulePresenter);
    }
}

