/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.data.SequentialData;
import com.jsyn.data.ShortSample;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.QueueDataEvent;
import com.jsyn.ports.UnitDataQueueCallback;
import com.jsyn.ports.UnitDataQueuePort;
import com.jsyn.unitgen.FixedRateMonoReader;
import junit.framework.TestCase;

public class TestQueuedDataPort
extends TestCase {
    Synthesizer synth;
    float[] floatData = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f};
    FloatSample floatSample;
    FixedRateMonoReader reader;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        this.synth.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.synth.stop();
        super.tearDown();
    }

    private void queueDirect(UnitDataQueuePort port, SequentialData data, int startFrame, int numFrames) {
        this.queueDirect(port, data, startFrame, numFrames, 0);
    }

    private void queueDirect(UnitDataQueuePort port, SequentialData data, int startFrame, int numFrames, int numLoops) {
        QueueDataCommand command = port.createQueueDataCommand(data, startFrame, numFrames);
        command.setNumLoops(numLoops);
        port.addQueuedBlock(command);
    }

    public void testQueueSingleShort() {
        short[] data = new short[]{234, -9876, 4567};
        ShortSample sample = new ShortSample(data.length, 1);
        sample.write(data);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        TestQueuedDataPort.assertEquals("start empty", false, dataQueue.hasMore());
        this.queueDirect(dataQueue, sample, 0, data.length);
        this.checkQueuedData(data, dataQueue, 0, data.length);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testQueueSingleFloat() {
        float[] data = new float[]{0.4f, 1.9f, 22.7f};
        FloatSample sample = new FloatSample(data.length, 1);
        sample.write(data);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        TestQueuedDataPort.assertEquals("start empty", false, dataQueue.hasMore());
        this.queueDirect(dataQueue, sample, 0, data.length);
        this.checkQueuedData(data, dataQueue, 0, data.length);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testQueueOutOfBounds() {
        float[] data = new float[]{0.4f, 1.9f, 22.7f};
        FloatSample sample = new FloatSample(data.length, 1);
        sample.write(data);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        boolean caught = false;
        try {
            this.queueDirect(dataQueue, sample, 0, sample.getNumFrames() + 1);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        TestQueuedDataPort.assertTrue("expect exception when we go past end of the array", caught);
        caught = false;
        try {
            this.queueDirect(dataQueue, sample, 1, sample.getNumFrames());
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        TestQueuedDataPort.assertTrue("expect exception when we go past end of the array", caught);
        caught = false;
        try {
            this.queueDirect(dataQueue, sample, -1, sample.getNumFrames());
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        TestQueuedDataPort.assertTrue("expect exception when we start before beginning of the array", caught);
    }

    public void testQueueMultiple() {
        short[] data = new short[]{234, 17777, -9876, 4567, -14287};
        ShortSample sample = new ShortSample(data.length, 1);
        sample.write(data);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        TestQueuedDataPort.assertEquals("start empty", false, dataQueue.hasMore());
        this.queueDirect(dataQueue, sample, 1, 3);
        this.queueDirect(dataQueue, sample, 0, 5);
        this.queueDirect(dataQueue, sample, 2, 2);
        this.checkQueuedData(data, dataQueue, 1, 3);
        this.checkQueuedData(data, dataQueue, 0, 5);
        this.checkQueuedData(data, dataQueue, 2, 2);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testQueueNoLoops() throws InterruptedException {
        System.out.println("testQueueNoLoops() ================");
        UnitDataQueuePort dataQueue = this.setupFloatSample();
        dataQueue.queueOn(this.floatSample, this.synth.createTimeStamp());
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 0, this.floatData.length);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testQueueLoopForever() throws InterruptedException {
        System.out.println("testQueueLoopForever() ================");
        UnitDataQueuePort dataQueue = this.setupFloatSample();
        dataQueue.queue(this.floatSample, 0, 3);
        dataQueue.queueLoop(this.floatSample, 3, 4);
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 0, 3);
        this.checkQueuedData(this.floatData, dataQueue, 3, 4);
        this.checkQueuedData(this.floatData, dataQueue, 3, 4);
        this.checkQueuedData(this.floatData, dataQueue, 3, 4);
        this.checkQueuedData(this.floatData, dataQueue, 3, 1);
        dataQueue.queue(this.floatSample, 3, 5);
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 4, 3);
        this.checkQueuedData(this.floatData, dataQueue, 3, 5);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testQueueLoopAtLeastOnce() throws InterruptedException {
        System.out.println("testQueueLoopAtLeastOnce() ================");
        UnitDataQueuePort dataQueue = this.setupFloatSample();
        dataQueue.queue(this.floatSample, 0, 3);
        dataQueue.queueLoop(this.floatSample, 3, 2);
        dataQueue.queue(this.floatSample, 5, 2);
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 0, 3);
        this.checkQueuedData(this.floatData, dataQueue, 3, 2);
        this.checkQueuedData(this.floatData, dataQueue, 5, 2);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testQueueNumLoops() throws InterruptedException {
        System.out.println("testQueueNumLoops() ================");
        UnitDataQueuePort dataQueue = this.setupFloatSample();
        dataQueue.queue(this.floatSample, 0, 2);
        int numLoopsA = 5;
        dataQueue.queueLoop((SequentialData)this.floatSample, 2, 3, numLoopsA);
        dataQueue.queue(this.floatSample, 4, 2);
        int numLoopsB = 3;
        dataQueue.queueLoop((SequentialData)this.floatSample, 3, 4, numLoopsB);
        dataQueue.queue(this.floatSample, 5, 2);
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 0, 2);
        int i = 0;
        while (i < numLoopsA + 1) {
            System.out.println("loop A #" + i);
            this.checkQueuedData(this.floatData, dataQueue, 2, 3);
            ++i;
        }
        this.checkQueuedData(this.floatData, dataQueue, 4, 2);
        i = 0;
        while (i < numLoopsB + 1) {
            System.out.println("loop B #" + i);
            this.checkQueuedData(this.floatData, dataQueue, 3, 4);
            ++i;
        }
        this.checkQueuedData(this.floatData, dataQueue, 5, 2);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    private UnitDataQueuePort setupFloatSample() {
        this.floatSample = new FloatSample(this.floatData.length, 1);
        this.floatSample.write(this.floatData);
        this.reader = new FixedRateMonoReader();
        this.synth.add(this.reader);
        UnitDataQueuePort dataQueue = this.reader.dataQueue;
        TestQueuedDataPort.assertEquals("start empty", false, dataQueue.hasMore());
        return dataQueue;
    }

    public void testQueueSustainLoop() throws InterruptedException {
        System.out.println("testQueueSustainLoop() ================");
        UnitDataQueuePort dataQueue = this.setupFloatSample();
        this.floatSample.setSustainBegin(2);
        this.floatSample.setSustainEnd(4);
        this.floatSample.setReleaseBegin(-1);
        this.floatSample.setReleaseEnd(-1);
        dataQueue.queueOn(this.floatSample, this.synth.createTimeStamp());
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 0, 2);
        this.checkQueuedData(this.floatData, dataQueue, 2, 2);
        this.checkQueuedData(this.floatData, dataQueue, 2, 2);
        this.checkQueuedData(this.floatData, dataQueue, 2, 1);
        dataQueue.queueOff(this.floatSample, true);
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 3, 5);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testQueueReleaseLoop() throws InterruptedException {
        System.out.println("testQueueReleaseLoop() ================");
        UnitDataQueuePort dataQueue = this.setupFloatSample();
        this.floatSample.setSustainBegin(-1);
        this.floatSample.setSustainEnd(-1);
        this.floatSample.setReleaseBegin(4);
        this.floatSample.setReleaseEnd(6);
        dataQueue.queueOn(this.floatSample, this.synth.createTimeStamp());
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 0, 4);
        this.checkQueuedData(this.floatData, dataQueue, 4, 2);
        this.checkQueuedData(this.floatData, dataQueue, 4, 2);
        this.checkQueuedData(this.floatData, dataQueue, 4, 2);
        dataQueue.queueOff(this.floatSample, true);
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 4, 2);
        this.checkQueuedData(this.floatData, dataQueue, 4, 2);
        TestQueuedDataPort.assertEquals("end full", true, dataQueue.hasMore());
    }

    public void testQueueSustainReleaseLoops() throws InterruptedException {
        System.out.println("testQueueSustainReleaseLoops() ================");
        UnitDataQueuePort dataQueue = this.setupFloatSample();
        this.floatSample.setSustainBegin(2);
        this.floatSample.setSustainEnd(4);
        this.floatSample.setReleaseBegin(5);
        this.floatSample.setReleaseEnd(7);
        dataQueue.queueOn(this.floatSample, this.synth.createTimeStamp());
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 0, 4);
        this.checkQueuedData(this.floatData, dataQueue, 2, 2);
        this.checkQueuedData(this.floatData, dataQueue, 2, 1);
        dataQueue.queueOff(this.floatSample, true);
        this.synth.sleepUntil(this.synth.getCurrentTime() + 0.01);
        this.checkQueuedData(this.floatData, dataQueue, 3, 2);
        this.checkQueuedData(this.floatData, dataQueue, 5, 2);
        this.checkQueuedData(this.floatData, dataQueue, 5, 2);
        TestQueuedDataPort.assertEquals("end full", true, dataQueue.hasMore());
    }

    private void checkQueuedData(short[] data, UnitDataQueuePort dataQueue, int offset, int numFrames) {
        int i = 0;
        while (i < numFrames) {
            TestQueuedDataPort.assertEquals("got data", true, dataQueue.hasMore());
            double value = dataQueue.readNextMonoDouble(this.synth.getFramePeriod());
            TestQueuedDataPort.assertEquals("data matches", (double)data[i + offset] / 32768.0, value, 1.0E-4);
            ++i;
        }
    }

    private void checkQueuedData(float[] data, UnitDataQueuePort dataQueue, int offset, int numFrames) {
        int i = 0;
        while (i < numFrames) {
            TestQueuedDataPort.assertEquals("got data", true, dataQueue.hasMore());
            double value = dataQueue.readNextMonoDouble(this.synth.getFramePeriod());
            TestQueuedDataPort.assertEquals("data matches", (double)data[i + offset], value, 1.0E-4);
            ++i;
        }
    }

    public void testQueueCallback() {
        float[] data = new float[]{0.2f, -8.9f, 2.7f};
        FloatSample sample = new FloatSample(data.length, 1);
        sample.write(data);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        TestQueuedDataPort.assertEquals("start empty", false, dataQueue.hasMore());
        TestQueueCallback callback = new TestQueueCallback();
        QueueDataCommand command = dataQueue.createQueueDataCommand(sample, 0, data.length);
        command.setCallback(callback);
        command.setNumLoops(2);
        dataQueue.addQueuedBlock(command);
        dataQueue.firePendingCallbacks();
        TestQueuedDataPort.assertEquals("not started yet", false, callback.gotStarted);
        TestQueuedDataPort.assertEquals("not looped yet", false, callback.gotLooped);
        TestQueuedDataPort.assertEquals("not finished yet", false, callback.gotFinished);
        this.checkQueuedData(data, dataQueue, 0, 1);
        dataQueue.firePendingCallbacks();
        TestQueuedDataPort.assertEquals("should be started now", true, callback.gotStarted);
        TestQueuedDataPort.assertEquals("not looped yet", false, callback.gotLooped);
        TestQueuedDataPort.assertEquals("not finished yet", false, callback.gotFinished);
        TestQueuedDataPort.assertEquals("check source of event", dataQueue, callback.lastEvent.getSource());
        TestQueuedDataPort.assertEquals("check sample", sample, callback.lastEvent.getSequentialData());
        TestQueuedDataPort.assertEquals("check loopCount", 2, callback.lastEvent.getLoopsLeft());
        this.checkQueuedData(data, dataQueue, 1, data.length - 1);
        dataQueue.firePendingCallbacks();
        TestQueuedDataPort.assertEquals("should be looped now", true, callback.gotLooped);
        TestQueuedDataPort.assertEquals("check loopCount", 1, callback.lastEvent.getLoopsLeft());
        TestQueuedDataPort.assertEquals("not finished yet", false, callback.gotFinished);
        this.checkQueuedData(data, dataQueue, 0, data.length);
        dataQueue.firePendingCallbacks();
        TestQueuedDataPort.assertEquals("check loopCount", 0, callback.lastEvent.getLoopsLeft());
        this.checkQueuedData(data, dataQueue, 0, data.length);
        dataQueue.firePendingCallbacks();
        TestQueuedDataPort.assertEquals("should be finished now", true, callback.gotFinished);
        TestQueuedDataPort.assertEquals("end empty", false, dataQueue.hasMore());
    }

    public void testImmediate() {
        float[] data = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f};
        FloatSample sample = new FloatSample(data.length, 1);
        sample.write(data);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        dataQueue.queue(sample);
        this.checkQueuedData(data, dataQueue, 0, 3);
        QueueDataCommand command = dataQueue.createQueueDataCommand(sample, 7, 3);
        command.setImmediate(true);
        command.run();
        this.checkQueuedData(data, dataQueue, 7, 3);
    }

    public void testCrossFade() {
        float[] data1 = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
        float[] data2 = new float[]{20.0f, 19.0f, 18.0f, 17.0f, 16.0f, 15.0f, 14.0f, 13.0f, 12.0f, 11.0f};
        FloatSample sample1 = new FloatSample(data1);
        FloatSample sample2 = new FloatSample(data2);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        dataQueue.queue(sample1, 0, 4);
        QueueDataCommand command = dataQueue.createQueueDataCommand(sample2, 1, 8);
        command.setCrossFadeIn(3);
        command.run();
        this.checkQueuedData(data1, dataQueue, 0, 4);
        int i = 0;
        while (i < 3) {
            double factor = (double)i / 3.0;
            double value = (1.0 - factor) * (double)data1[i + 4] + factor * (double)data2[i + 1];
            System.out.println("i = " + i + ", factor = " + factor + ", value = " + value);
            double actual = dataQueue.readNextMonoDouble(this.synth.getFramePeriod());
            TestQueuedDataPort.assertEquals("crossfade " + i, value, actual, 1.0E-5);
            ++i;
        }
        this.checkQueuedData(data2, dataQueue, 4, 5);
    }

    public void testImmediateCrossFade() {
        float[] data1 = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f};
        float[] data2 = new float[]{20.0f, 19.0f, 18.0f, 17.0f, 16.0f, 15.0f, 14.0f, 13.0f, 12.0f, 11.0f};
        FloatSample sample1 = new FloatSample(data1);
        FloatSample sample2 = new FloatSample(data2);
        UnitDataQueuePort dataQueue = new UnitDataQueuePort("test");
        dataQueue.queue(sample1, 0, 4);
        int beforeInterrupt = 2;
        this.checkQueuedData(data1, dataQueue, 0, beforeInterrupt);
        QueueDataCommand command = dataQueue.createQueueDataCommand(sample2, 1, 8);
        command.setImmediate(true);
        command.setCrossFadeIn(3);
        command.run();
        int i = 0;
        while (i < 3) {
            double factor = (double)i / 3.0;
            double value = (1.0 - factor) * (double)data1[i + beforeInterrupt] + factor * (double)data2[i + 1];
            System.out.println("i = " + i + ", factor = " + factor + ", value = " + value);
            double actual = dataQueue.readNextMonoDouble(this.synth.getFramePeriod());
            TestQueuedDataPort.assertEquals("crossfade " + i, value, actual, 1.0E-5);
            ++i;
        }
        this.checkQueuedData(data2, dataQueue, 4, 5);
    }

    class TestQueueCallback
    implements UnitDataQueueCallback {
        boolean gotStarted = false;
        boolean gotLooped = false;
        boolean gotFinished = false;
        QueueDataEvent lastEvent;

        TestQueueCallback() {
        }

        @Override
        public void started(QueueDataEvent event) {
            System.out.println("Callback started.");
            this.gotStarted = true;
            this.lastEvent = event;
        }

        @Override
        public void looped(QueueDataEvent event) {
            System.out.println("Callback looped.");
            this.gotLooped = true;
            this.lastEvent = event;
        }

        @Override
        public void finished(QueueDataEvent event) {
            System.out.println("Callback finished.");
            this.gotFinished = true;
            this.lastEvent = event;
        }
    }
}

