/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

import com.jsyn.midi.MessageParser;
import com.jsyn.util.MultiChannelSynthesizer;

public class MidiSynthesizer
extends MessageParser {
    private MultiChannelSynthesizer multiSynth;

    public MidiSynthesizer(MultiChannelSynthesizer multiSynth) {
        this.multiSynth = multiSynth;
    }

    @Override
    public void controlChange(int channel, int index, int value) {
        double normalized = (double)value * 0.007874015748031496;
        switch (index) {
            case 1: {
                double vibratoDepth = 0.1 * normalized;
                System.out.println("vibratoDepth = " + vibratoDepth);
                this.multiSynth.setVibratoDepth(channel, vibratoDepth);
                break;
            }
            case 74: {
                this.multiSynth.setTimbre(channel, normalized);
                break;
            }
            case 7: {
                this.multiSynth.setVolume(channel, normalized);
                break;
            }
            case 10: {
                this.multiSynth.setPan(channel, normalized * 2.0 - 1.0);
            }
        }
    }

    @Override
    public void registeredParameter(int channel, int index14, int value14) {
        switch (index14) {
            case 0: {
                int semitones = value14 >> 7;
                int cents = value14 & 0x7F;
                double bendRange = (double)semitones + (double)cents * 0.01;
                this.multiSynth.setBendRange(channel, bendRange);
                break;
            }
        }
    }

    @Override
    public void programChange(int channel, int program) {
        this.multiSynth.programChange(channel, program);
    }

    @Override
    public void channelPressure(int channel, int value) {
        double normalized = (double)value * 0.007874015748031496;
        this.multiSynth.setPressure(channel, normalized);
    }

    @Override
    public void noteOff(int channel, int noteNumber, int velocity) {
        this.multiSynth.noteOff(channel, noteNumber, velocity);
    }

    @Override
    public void noteOn(int channel, int noteNumber, int velocity) {
        this.multiSynth.noteOn(channel, noteNumber, velocity);
    }

    @Override
    public void pitchBend(int channel, int bend) {
        double offset = (double)(bend - 8192) * 1.220703125E-4;
        this.multiSynth.setPitchBend(channel, offset);
    }

    public void onReceive(byte[] bytes, int i, int length) {
        this.parse(bytes);
    }
}

