/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.midi;

public class MessageParser {
    private int[] parameterIndices = new int[16];
    private int[] parameterValues = new int[16];
    private int BIT_NON_RPM = 16384;
    private int MASK_14BIT = 16383;

    public void parse(byte[] message) {
        byte status = message[0];
        int command = status & 0xF0;
        int channel = status & 0xF;
        switch (command) {
            case 144: {
                byte velocity = message[2];
                if (velocity == 0) {
                    this.noteOff(channel, message[1], velocity);
                    break;
                }
                this.noteOn(channel, message[1], velocity);
                break;
            }
            case 128: {
                this.noteOff(channel, message[1], message[2]);
                break;
            }
            case 160: {
                this.polyphonicAftertouch(channel, message[1], message[2]);
                break;
            }
            case 208: {
                this.channelPressure(channel, message[1]);
                break;
            }
            case 176: {
                this.rawControlChange(channel, message[1], message[2]);
                break;
            }
            case 192: {
                this.programChange(channel, message[1]);
                break;
            }
            case 224: {
                int bend = (message[2] << 7) + message[1];
                this.pitchBend(channel, bend);
            }
        }
    }

    public void rawControlChange(int channel, int index, int value) {
        switch (index) {
            case 6: {
                this.parameterValues[channel] = value << 7;
                this.fireParameterChange(channel);
                break;
            }
            case 38: {
                int paramValue = this.parameterValues[channel] & 0xFFFFFF80;
                this.parameterValues[channel] = paramValue |= value;
                this.fireParameterChange(channel);
                break;
            }
            case 98: {
                int paramIndex = this.parameterIndices[channel] & 0xFFFFFF80;
                this.parameterIndices[channel] = paramIndex |= value | this.BIT_NON_RPM;
                break;
            }
            case 99: {
                this.parameterIndices[channel] = value << 7 | this.BIT_NON_RPM;
                break;
            }
            case 100: {
                int paramIndex = this.parameterIndices[channel] & 0xFFFFFF80;
                this.parameterIndices[channel] = paramIndex |= value;
                break;
            }
            case 101: {
                this.parameterIndices[channel] = value << 7;
                break;
            }
            default: {
                this.controlChange(channel, index, value);
            }
        }
    }

    private void fireParameterChange(int channel) {
        int paramIndex = this.parameterIndices[channel];
        if ((paramIndex & this.BIT_NON_RPM) == 0) {
            this.registeredParameter(channel, paramIndex, this.parameterValues[channel]);
        } else {
            this.nonRegisteredParameter(channel, paramIndex & this.MASK_14BIT, this.parameterValues[channel]);
        }
    }

    public void nonRegisteredParameter(int channel, int index14, int value14) {
    }

    public void registeredParameter(int channel, int index14, int value14) {
    }

    public void pitchBend(int channel, int bend) {
    }

    public void programChange(int channel, int program) {
    }

    public void polyphonicAftertouch(int channel, int pitch, int pressure) {
    }

    public void channelPressure(int channel, int pressure) {
    }

    public void controlChange(int channel, int index, int value) {
    }

    public void noteOn(int channel, int pitch, int velocity) {
    }

    public void noteOff(int channel, int pitch, int velocity) {
    }
}

