/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.syntona.plugin.BarGraphElement;
import java.awt.Color;
import java.awt.Graphics;

public class VolumeMeterElement
extends BarGraphElement {
    private static final double YELLOW_THRESHOLD = 0.8;
    private static final double RED_THRESHOLD = 1.0;

    public VolumeMeterElement(int orientation, double max) {
        super(orientation, 0.0, 0.0, max);
    }

    @Override
    public void paintBar(Graphics g) {
        double value = this.get();
        if (value > 0.8) {
            g.setColor(Color.GREEN);
            this.drawValueRegion(g, this.getMin(), 0.8);
            if (value > 1.0) {
                g.setColor(Color.YELLOW);
                this.drawValueRegion(g, 0.8, 1.0);
                g.setColor(Color.RED);
                this.drawValueRegion(g, 1.0, value);
            } else {
                g.setColor(Color.YELLOW);
                this.drawValueRegion(g, 0.8, value);
            }
        } else {
            g.setColor(Color.GREEN);
            this.drawValueRegion(g, this.getMin(), value);
        }
    }

    private void drawValueRegion(Graphics g, double v1, double v2) {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.getOrientation() == 0) {
            int x1 = (int)((double)width * (v1 - this.getMin()) * this.getScalar());
            int w = (int)((double)width * (v2 - v1) * this.getScalar());
            if (w > 0) {
                g.fillRect(x1, 0, w, height);
            }
        }
    }
}

