/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.model.core.OnOffModule;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaPluginServices;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class PlayKeyModulePresenter
extends ModulePresenter {
    private KeyListener playKeyListener;
    private OnOffModule onOffModule;

    public PlayKeyModulePresenter() {
        this(new OnOffModule("Send PlayKeys character to \"on\" or \"off\" jack."));
    }

    public PlayKeyModulePresenter(OnOffModule onOffModule) {
        super(onOffModule);
        this.onOffModule = onOffModule;
        this.playKeyListener = new VoiceKeyListener();
        SyntonaPluginServices.getInstance().addPlayKeyListener(this.playKeyListener);
    }

    public void keyOn(char key) {
        this.sendOnMessage(key);
    }

    public void keyOff(char key) {
        this.sendOffMessage(key);
    }

    public void sendOnMessage(double value) {
        this.onOffModule.sendOnMessage(value);
    }

    public void sendOffMessage(double value) {
        this.onOffModule.sendOffMessage(value);
    }

    @Override
    public void delete() {
        if (this.playKeyListener != null) {
            SyntonaPluginServices.getInstance().removePlayKeyListener(this.playKeyListener);
            this.playKeyListener = null;
        }
        super.delete();
    }

    private class VoiceKeyListener
    implements KeyListener {
        private char lastKeyDown;

        private VoiceKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            char key = e.getKeyChar();
            if ((key = Character.toUpperCase(key)) != this.lastKeyDown) {
                this.lastKeyDown = key;
                PlayKeyModulePresenter.this.keyOn(key);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            char key = e.getKeyChar();
            if ((key = Character.toUpperCase(key)) == this.lastKeyDown) {
                this.lastKeyDown = '\u0000';
                PlayKeyModulePresenter.this.keyOff(key);
            }
        }
    }
}

