/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.gui.AlertUser;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.gui.patch.PatchModuleView;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.XMLDOMSaver;
import com.syntona.model.core.PatchModule;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaModule;
import com.syntona.tools.FileTools;
import com.syntona.tools.ModificationListener;
import com.syntona.tools.ModificationTracker;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PatchModulePresenter
extends ModulePresenter {
    private static final int PASTE_OFFSET_INCREMENT = 20;
    private static Logger logger = Logger.getLogger(PatchModulePresenter.class.getName());
    private PatchModule patchModule;
    private CopyOnWriteArrayList<ModulePresenter> presenters = new CopyOnWriteArrayList();
    private PatchFrame patchFrame;
    private ModificationTracker modificationTracker = new ModificationTracker();
    private HashSet<String> uniqueNames = new HashSet();
    private int pasteOffsetX;
    private int pasteOffsetY;

    public PatchModulePresenter() {
        this(new PatchModule());
    }

    public PatchModulePresenter(PatchModule patchModule) {
        super(patchModule);
        this.patchModule = patchModule;
        this.setView(new PatchModuleView(this));
    }

    public void freeUniqueName(String name) {
        this.uniqueNames.remove(name);
    }

    public void addUniqueName(String name) {
        this.uniqueNames.add(name);
    }

    public boolean isNameInUse(String name) {
        return this.uniqueNames.contains(name);
    }

    public String makeNameUnique(String original) {
        int index = 2;
        String candidate = original;
        while (this.isNameInUse(candidate)) {
            candidate = String.valueOf(original) + index;
            ++index;
        }
        this.addUniqueName(candidate);
        return candidate;
    }

    public void add(ModulePresenter presenter) {
        logger.info("add module: " + presenter.getModule().getName());
        this.presenters.add(presenter);
        this.patchModule.add(presenter.getModule());
        presenter.addedToPatch(this);
        this.markDirty();
        this.onPresenterAdded(presenter);
    }

    public void onPresenterAdded(ModulePresenter presenter) {
    }

    public void setUserWarning(String text) {
        if (this.patchFrame != null) {
            this.patchFrame.getPatchEditor().setUserWarning(text);
        }
    }

    public void clearUserWarning() {
        if (this.patchFrame != null) {
            this.patchFrame.getPatchEditor().clearUserWarning();
        }
    }

    public void remove(ModulePresenter presenter) {
        logger.info("remove module: " + presenter.getModule().getName());
        this.patchModule.remove(presenter.getModule());
        this.presenters.remove(presenter);
        this.freeUniqueName(presenter.getModule().getName());
        if (this.patchFrame != null) {
            this.patchFrame.getPatchEditor().removeModulePresenter(presenter);
        }
        this.onPresenterRemoved(presenter);
    }

    public void onPresenterRemoved(ModulePresenter presenter) {
    }

    public ModulePresenter[] getPresenters() {
        return this.presenters.toArray(new ModulePresenter[0]);
    }

    public PatchModule getPatchModule() {
        return this.patchModule;
    }

    @Override
    public Component showMainEditor() {
        System.out.println("showEditor, patchFrame = " + this.patchFrame);
        if (this.patchFrame == null) {
            PatchFrame parentPatchFrame = this.getParentPatchFrame();
            if (parentPatchFrame == null) {
                System.out.println("no parentPatchFrame or editor");
                return null;
            }
            this.patchFrame = parentPatchFrame.getTopPatchEditor().openPatchFrame(this);
        }
        this.patchFrame.getTopPatchEditor().setFrontPatchFrame(this.patchFrame);
        this.patchFrame.setVisible(true);
        this.patchFrame.toFront();
        try {
            this.patchFrame.setSelected(true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return this.patchFrame;
    }

    public SyntonaSaver createSyntonaSaver() throws ParserConfigurationException {
        return new XMLDOMSaver();
    }

    public SyntonaLoader createSyntonaLoader() {
        return new XMLDOMLoader();
    }

    public void saveContents(SyntonaSaver saver, boolean topLevel, ModulePresenter[] modulePresenters) throws ParserConfigurationException {
        if (topLevel || this.getFile() == null || saver.getTargetFile() == null) {
            ArrayList<SyntonaModule> selectedModules = new ArrayList<SyntonaModule>();
            saver.beginElement("modules");
            int i = 0;
            ModulePresenter[] modulePresenterArray = modulePresenters;
            int n = modulePresenters.length;
            int n2 = 0;
            while (n2 < n) {
                ModulePresenter presenter = modulePresenterArray[n2];
                SyntonaModule module = presenter.getModule();
                selectedModules.add(module);
                module.setSaveId(i++);
                presenter.save(saver, false);
                ++n2;
            }
            saver.endElement();
            this.patchModule.saveConnections(saver, selectedModules);
            this.markClean();
        } else {
            this.saveFileLink(saver);
            this.saveIfDirty();
        }
    }

    @Override
    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        this.saveContents(saver, topLevel, this.presenters.toArray(new ModulePresenter[0]));
    }

    @Override
    public boolean saveIfDirty() throws ParserConfigurationException {
        boolean cancelled = false;
        for (ModulePresenter presenter : this.presenters) {
            cancelled = presenter.saveIfDirty();
            if (cancelled) break;
        }
        if (!cancelled && this.isDirty() && (this.getParent() == null || this.getFile() != null)) {
            this.closeAllEditors();
            String message = "Do you want to SAVE your changes?";
            String title = "Patch \"" + this.getName() + "\" Modified";
            int result = this.askUserYesNoCancel(message, title);
            if (result == 0) {
                File saveFile = SyntonaEngine.getInstance().getGUIService().askSaveFile(this.getFile());
                if (saveFile != null) {
                    try {
                        this.save(saveFile);
                    }
                    catch (Exception e) {
                        AlertUser.showError(e);
                        logger.log(Level.WARNING, e.getMessage(), e);
                        cancelled = true;
                    }
                } else {
                    cancelled = true;
                }
            } else if (result != 1) {
                cancelled = true;
            }
        }
        return cancelled;
    }

    private void closeAllEditors() {
        for (ModulePresenter presenter : this.presenters) {
            presenter.hideMainEditor();
        }
    }

    public int askUserYesNoCancel(String message, String title) {
        int result;
        if (this.getPatchFrame() != null) {
            this.getPatchFrame().moveToFront();
            result = JOptionPane.showInternalConfirmDialog(this.getPatchFrame(), message, title, 1, 2);
        } else {
            result = JOptionPane.showConfirmDialog(null, message, title, 1, 2);
        }
        return result;
    }

    public String getName() {
        if (this.getFile() != null) {
            return this.getFile().getName();
        }
        return this.getModule().getName();
    }

    private void saveFileLink(SyntonaSaver saver) {
        saver.beginElement("link");
        saver.addAttribute("xml:link", "simple");
        String path = FileTools.makePathRelative(this.getFile().getAbsolutePath(), saver.getTargetFile());
        saver.addAttribute("href", path);
        saver.endElement();
    }

    public void saveTop(SyntonaSaver saver) throws ParserConfigurationException {
        saver.beginElement("syntona");
        saver.addAttribute("version", "0.5.13");
        this.save(saver, true);
        saver.endElement();
    }

    public byte[] copy(ModulePresenter[] selectedPresenters) throws ParserConfigurationException {
        SyntonaSaver saver = this.createSyntonaSaver();
        saver.beginElement("syntona");
        saver.beginElement("module");
        this.saveContents(saver, true, selectedPresenters);
        saver.endElement();
        saver.endElement();
        saver.print();
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(outByteStream);
        saver.render(streamResult);
        this.pasteOffsetX = 20;
        this.pasteOffsetY = 20;
        return outByteStream.toByteArray();
    }

    public void save(File saveFile) throws ParserConfigurationException {
        if (this.checkFileRecursion(saveFile, 0)) {
            throw new RuntimeException("A child of this patch is already saved with the same name!");
        }
        SyntonaSaver saver = this.createSyntonaSaver();
        saver.setTargetFile(saveFile);
        this.saveTop(saver);
        saver.print();
        saver.render(saveFile);
        this.setFile(saveFile);
    }

    @Override
    public boolean checkFileRecursion(File saveFile, int level) {
        if (super.checkFileRecursion(saveFile, level)) {
            return true;
        }
        ++level;
        for (ModulePresenter presenter : this.presenters) {
            if (!presenter.checkFileRecursion(saveFile, level)) continue;
            return true;
        }
        return false;
    }

    public void paste(byte[] pasteBuffer) throws ParserConfigurationException, SAXException, IOException {
        SyntonaLoader loader = this.createSyntonaLoader();
        loader.setAutoSelectEnabled(true);
        this.patchFrame.deselectAll();
        loader.setOffsetX(this.pasteOffsetX);
        loader.setOffsetY(this.pasteOffsetY);
        this.pasteOffsetX += 20;
        this.pasteOffsetY += 20;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pasteBuffer);
        loader.parse(inputStream);
        this.loadTopPatch(loader);
    }

    public void load(File loadFile) throws ParserConfigurationException, SAXException, IOException {
        SyntonaLoader loader = this.createSyntonaLoader();
        this.setFile(loadFile);
        loader.parse(loadFile);
        this.loadTopPatch(loader);
    }

    public void loadTopPatch(SyntonaLoader loader) throws ParserConfigurationException, SAXException, IOException {
        Element syntonaElement = loader.getDocument().getDocumentElement();
        Element topModuleElement = XMLDOMLoader.getChildByTagName(syntonaElement, "module");
        this.loadContents(loader, topModuleElement);
        this.onLoad();
        if (this.getPatchFrame() != null) {
            this.getPatchFrame().repaint();
        }
    }

    @Override
    public void onLoad() {
        for (ModulePresenter presenter : this.presenters) {
            presenter.onLoad();
        }
        this.markClean();
    }

    public ModulePresenter loadSubPatch(File loadFile) throws ParserConfigurationException, SAXException, IOException {
        SyntonaLoader loader = this.createSyntonaLoader();
        loader.parse(loadFile);
        Element syntonaElement = loader.getDocument().getDocumentElement();
        Element topModuleElement = XMLDOMLoader.getChildByTagName(syntonaElement, "module");
        ModulePresenter addedPresenter = this.loadSubModule(loader, topModuleElement);
        addedPresenter.setFile(loadFile);
        return addedPresenter;
    }

    @Override
    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException, SAXException, IOException {
        Element modulesElement = XMLDOMLoader.getChildByTagName(moduleElement, "modules");
        Element linkElement = XMLDOMLoader.getChildByTagName(moduleElement, "link");
        if (linkElement != null) {
            this.loadContentsFromLinkedFile(loader, moduleElement, linkElement);
        } else if (modulesElement != null) {
            this.loadContentsInline(loader, moduleElement, modulesElement);
        } else {
            System.err.println("No link or modules element in loaded file!");
        }
        super.loadContents(loader, moduleElement);
    }

    private void loadContentsFromLinkedFile(SyntonaLoader loader, Element element, Element linkElement) throws ParserConfigurationException, SAXException, IOException {
        String fileName = linkElement.getAttribute("href");
        fileName = FileTools.convertFileSeparatorsToHost(fileName);
        File fileToLoad = FileTools.resolveRelativePath(loader.getLoadFile(), fileName);
        if (fileToLoad == null) {
            String title;
            String message = "Do you want to find the missing file: " + fileName;
            int result = this.askUserYesNoCancel(message, title = "Missing subpatch file!");
            if (result == 0) {
                File missingFile = new File(fileName);
                File existingParent = FileTools.findExistingParent(fileName);
                if (existingParent == null) {
                    existingParent = loader.getLoadFile().getParentFile();
                }
                File lookHere = new File(existingParent, missingFile.getName());
                fileToLoad = SyntonaEngine.getInstance().getGUIService().askOpenFile(lookHere);
            }
            if (fileToLoad == null) {
                return;
            }
            this.markDirty();
        }
        this.load(fileToLoad);
    }

    public void loadContentsInline(SyntonaLoader loader, Element element, Element modulesElement) throws ParserConfigurationException, SAXException, IOException {
        Element connectionsElement;
        List<Element> outputNodeList;
        ArrayList<Integer> moduleIds = new ArrayList<Integer>();
        List<Element> nl = XMLDOMLoader.getChildrenByTagName(modulesElement, "module");
        if (nl != null) {
            int i = 0;
            while (i < nl.size()) {
                Element moduleElement = nl.get(i);
                ModulePresenter addedPresenter = this.loadSubModule(loader, moduleElement);
                moduleIds.add(addedPresenter.getModule().getId());
                ++i;
            }
        }
        if ((outputNodeList = XMLDOMLoader.getChildrenByTagName(connectionsElement = XMLDOMLoader.getChildByTagName(element, "connections"), "output")) != null) {
            int i = 0;
            while (i < outputNodeList.size()) {
                Element outputElement = outputNodeList.get(i);
                String sourceSaveIdText = outputElement.getAttribute("id");
                int sourceModuleSaveId = Integer.parseInt(sourceSaveIdText);
                int sourceModuleId = (Integer)moduleIds.get(sourceModuleSaveId);
                String sourceJackName = outputElement.getAttribute("jack");
                List<Element> inputNodeList = XMLDOMLoader.getChildrenByTagName(outputElement, "input");
                if (inputNodeList != null) {
                    int j = 0;
                    while (j < inputNodeList.size()) {
                        Element inputElement = inputNodeList.get(j);
                        String targetIdSaveText = inputElement.getAttribute("id");
                        int targetModuleSaveId = Integer.parseInt(targetIdSaveText);
                        if (targetModuleSaveId < moduleIds.size()) {
                            int targetModuleId = (Integer)moduleIds.get(targetModuleSaveId);
                            String targetJackName = inputElement.getAttribute("jack");
                            System.out.println("Connect #" + sourceSaveIdText + ":" + sourceJackName + " to " + "#" + targetIdSaveText + ":" + targetJackName);
                            this.getEngine().sendConnectJacks(sourceModuleId, sourceJackName, targetModuleId, targetJackName);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private EngineController getEngine() {
        return SyntonaEngine.getInstance();
    }

    private ModulePresenter loadSubModule(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException, SAXException, IOException {
        String type = moduleElement.getAttribute("type");
        String loadedName = moduleElement.getAttribute("name");
        String bundleName = moduleElement.getAttribute("bundle");
        Bundle bundle = this.getEngine().getBundle(bundleName);
        ModulePresenter addedPresenter = this.getEngine().addModuleNow(bundle, this, type, 20, 20);
        String currentName = addedPresenter.getModule().getName();
        if (!loadedName.equals(currentName)) {
            this.freeUniqueName(currentName);
            loadedName = this.makeNameUnique(loadedName);
        }
        addedPresenter.getModule().setName(loadedName);
        addedPresenter.getView().setSelected(loader.isAutoSelectEnabled());
        addedPresenter.getView().load(loader, moduleElement);
        int savedX = loader.getOffsetX();
        int savedY = loader.getOffsetY();
        loader.setOffsetX(0);
        loader.setOffsetY(0);
        addedPresenter.loadContents(loader, moduleElement);
        loader.setOffsetX(savedX);
        loader.setOffsetY(savedY);
        return addedPresenter;
    }

    @Override
    public void setFile(File file) {
        super.setFile(file);
        if (this.patchFrame != null) {
            this.patchFrame.updateTitle();
        }
    }

    public void setPatchFrame(PatchFrame patchFrame) {
        this.patchFrame = patchFrame;
    }

    public PatchFrame getPatchFrame() {
        return this.patchFrame;
    }

    public void clear() {
        ModulePresenter[] all;
        this.setFile(null);
        ModulePresenter[] modulePresenterArray = all = this.presenters.toArray(new ModulePresenter[0]);
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            ModulePresenter presenter = modulePresenterArray[n2];
            presenter.delete();
            ++n2;
        }
        if (this.patchFrame != null) {
            this.patchFrame.getTopPatchEditor().repaint();
        }
    }

    @Override
    public void delete() {
        this.clear();
        if (this.patchFrame != null) {
            this.patchFrame.hide();
        }
        super.delete();
    }

    public void addModificationListener(ModificationListener listener) {
        this.modificationTracker.addModificationListener(listener);
    }

    @Override
    public void markDirty() {
        this.modificationTracker.setDirty(true);
        if (this.getParent() != null && this.getFile() == null) {
            this.getParent().markDirty();
        }
    }

    @Override
    public void markClean() {
        this.modificationTracker.setDirty(false);
    }

    public boolean isDirty() {
        return this.modificationTracker.isDirty();
    }

    public PatchModulePresenter getTopOfSaveTree() {
        if (this.getParent() == null || this.getFile() != null) {
            return this;
        }
        return this.getParent().getTopOfSaveTree();
    }

    public void addCustomTools(JToolBar toolbar) {
    }
}

