/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreElementPlayer;
import com.softsynth.score.ScoreList;

public class Column
extends ScoreList {
    @Override
    public ScoreElementPlayer start(ScoreElementPlayer parentPlayer, double time) {
        ColumnPlayer player = new ColumnPlayer(this, parentPlayer);
        player.start(time);
        return player;
    }

    @Override
    public String toString() {
        String text = "[ ";
        for (ScoreElement element : this.getElements()) {
            text = String.valueOf(text) + element + ", ";
        }
        text = String.valueOf(text) + "]";
        return text;
    }

    private static class ColumnPlayer
    extends ScoreElementPlayer {
        Column column;
        private double nextTime;
        private boolean done;
        private ScoreElementPlayer[] playing;

        private ColumnPlayer(Column column, ScoreElementPlayer parentPlayer) {
            super(column, parentPlayer);
            this.column = column;
            this.done = false;
        }

        @Override
        public void start(double time) {
            super.start(time);
            this.nextTime = time;
            this.playing = new ScoreElementPlayer[this.column.size()];
            int i = 0;
            for (ScoreElement element : this.column.getElements()) {
                this.playing[i++] = element.start(this, time);
            }
        }

        @Override
        public double advance(double time) {
            if (time >= this.nextTime) {
                double minTime = Double.MAX_VALUE;
                boolean allDone = true;
                ScoreElementPlayer[] scoreElementPlayerArray = this.playing;
                int n = this.playing.length;
                int n2 = 0;
                while (n2 < n) {
                    ScoreElementPlayer player = scoreElementPlayerArray[n2];
                    if (!player.isDone()) {
                        double temp = player.advance(time);
                        if (temp < minTime) {
                            minTime = temp;
                        }
                        allDone &= player.isDone();
                    }
                    ++n2;
                }
                this.done = allDone;
                this.nextTime = minTime;
            }
            return this.nextTime;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }
}

