/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.DoubleTable;
import com.jsyn.data.Function;
import com.jsyn.unitgen.FunctionEvaluator;
import junit.framework.TestCase;

public class TestFunction
extends TestCase {
    Synthesizer synth;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        this.synth.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.synth.stop();
    }

    public void testDoubleTable() {
        double[] data = new double[]{2.0, 0.0, 3.0};
        DoubleTable table = new DoubleTable(data);
        TestFunction.assertEquals("DoubleTable below", (Object)2.0, (Object)table.evaluate(-1.4));
        TestFunction.assertEquals("DoubleTable edge", (Object)2.0, (Object)table.evaluate(-1.0));
        TestFunction.assertEquals("DoubleTable mid", (Object)1.0, (Object)table.evaluate(-0.5));
        TestFunction.assertEquals("DoubleTable zero", (Object)0.0, (Object)table.evaluate(0.0));
        TestFunction.assertEquals("DoubleTable mid", (Object)0.75, (Object)table.evaluate(0.25));
        TestFunction.assertEquals("DoubleTable above", (Object)3.0, (Object)table.evaluate(1.3));
    }

    public void testFunctionEvaluator() throws InterruptedException {
        FunctionEvaluator shaper = new FunctionEvaluator();
        this.synth.add(shaper);
        shaper.start();
        Function cuber = new Function(){

            @Override
            public double evaluate(double x) {
                return x * x * x;
            }
        };
        shaper.function.set(cuber);
        shaper.input.set(0.5);
        this.synth.sleepFor(0.001);
        TestFunction.assertEquals("Cuber", (Object)0.125, (Object)shaper.output.getValue());
    }
}

