/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.FilterFourPoles;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.PitchDetector;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.ZeroCrossingCounter;
import javax.swing.JApplet;

public class CalibrateMoogFilter
extends JApplet {
    private Synthesizer synth;
    private UnitOscillator oscillator;
    private SineOscillator reference;
    ZeroCrossingCounter zeroCounter;
    PitchDetector pitchDetector;
    ZeroCrossingCounter sineZeroCounter;
    PitchDetector sinePitchDetector;
    private FilterFourPoles filterMoog;
    private LineOut lineOut;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        this.oscillator = new SawtoothOscillatorBL();
        this.synth.add(this.oscillator);
        this.reference = new SineOscillator();
        this.synth.add(this.reference);
        this.filterMoog = new FilterFourPoles();
        this.synth.add(this.filterMoog);
        this.pitchDetector = new PitchDetector();
        this.synth.add(this.pitchDetector);
        this.sinePitchDetector = new PitchDetector();
        this.synth.add(this.sinePitchDetector);
        this.zeroCounter = new ZeroCrossingCounter();
        this.synth.add(this.zeroCounter);
        this.sineZeroCounter = new ZeroCrossingCounter();
        this.synth.add(this.sineZeroCounter);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.oscillator.output.connect(this.filterMoog.input);
        this.filterMoog.output.connect(this.zeroCounter.input);
        this.zeroCounter.output.connect(this.pitchDetector.input);
        this.reference.output.connect(0, this.lineOut.input, 0);
        this.filterMoog.output.connect(0, this.lineOut.input, 1);
        this.reference.output.connect(this.sineZeroCounter.input);
        this.sineZeroCounter.output.connect(this.sinePitchDetector.input);
        this.oscillator.frequency.set(130.0);
        this.oscillator.amplitude.set(0.001);
        this.filterMoog.frequency.set(440.0);
        this.filterMoog.Q.set(4.1);
    }

    @Override
    public void start() {
        this.synth.start();
        this.pitchDetector.start();
        this.sinePitchDetector.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.pitchDetector.stop();
        this.sinePitchDetector.stop();
        this.lineOut.stop();
        this.synth.stop();
    }

    public void test() {
        this.init();
        this.start();
        try {
            this.calibrate();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.stop();
    }

    private void calibrate() throws InterruptedException {
        this.synth.sleepFor(2.0);
        double freq = 100.0;
        System.out.printf("freq, moogFreq, ratio, moogConf, sineFreq, sineConf, moogZRate, sineZRate\n", new Object[0]);
        long startingFrameCount = this.synth.getFrameCount();
        long startingMoogZeroCount = this.zeroCounter.getCount();
        long startingSineZeroCount = this.sineZeroCounter.getCount();
        int i = 0;
        while (i < 50) {
            this.reference.frequency.set(freq);
            this.filterMoog.frequency.set(freq);
            this.synth.sleepFor(2.0);
            long endingFrameCount = this.synth.getFrameCount();
            long elapsedFrames = endingFrameCount - startingFrameCount;
            startingFrameCount = endingFrameCount;
            long endingMoogZeroCount = this.zeroCounter.getCount();
            long elapsedMoogZeros = endingMoogZeroCount - startingMoogZeroCount;
            startingMoogZeroCount = endingMoogZeroCount;
            long endingSineZeroCount = this.sineZeroCounter.getCount();
            long elapsedSineZeros = endingSineZeroCount - startingSineZeroCount;
            startingSineZeroCount = endingSineZeroCount;
            double moogZeroRate = (double)elapsedMoogZeros * (double)this.synth.getFrameRate() / (double)elapsedFrames;
            double sineZeroRate = (double)elapsedSineZeros * (double)this.synth.getFrameRate() / (double)elapsedFrames;
            double moogMeasuredFreq = this.pitchDetector.frequency.get();
            double moogConfidence = this.pitchDetector.confidence.get();
            double sineMeasuredFreq = this.sinePitchDetector.frequency.get();
            double sineConfidence = this.sinePitchDetector.confidence.get();
            double ratio = freq / moogMeasuredFreq;
            System.out.printf("%7.2f, %8.5f, %7.5f, %4.2f, %8.5f, %4.2f, %8.4f, %8.4f\n", freq, moogMeasuredFreq, ratio, moogConfidence, sineMeasuredFreq, sineConfidence, moogZeroRate, sineZeroRate);
            freq *= 1.1;
            ++i;
        }
    }

    public static void main(String[] args) {
        new CalibrateMoogFilter().test();
    }
}

