/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.unitgen.FunctionEvaluator;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.util.SampleLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class PlaySampleWaveShaper {
    private Synthesizer synth;
    private LineOut lineOut;

    private void test() {
        URL sampleFile;
        try {
            sampleFile = new URL("http://www.softsynth.com/samples/Clarinet.wav");
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            return;
        }
        this.synth = JSyn.createSynthesizer();
        try {
            this.lineOut = new LineOut();
            this.synth.add(this.lineOut);
            SampleLoader.setJavaSoundPreferred(false);
            FloatSample sample = SampleLoader.loadFloatSample(sampleFile);
            System.out.println("Sample has: channels  = " + sample.getChannelsPerFrame());
            System.out.println("            frames    = " + sample.getNumFrames());
            System.out.println("            rate      = " + sample.getFrameRate());
            System.out.println("            loopStart = " + sample.getSustainBegin());
            System.out.println("            loopEnd   = " + sample.getSustainEnd());
            if (sample.getChannelsPerFrame() != 1) {
                throw new RuntimeException("Can only use mono samples.");
            }
            System.out.println("eval -1.1 = " + sample.evaluate(-1.1));
            System.out.println("eval -1.0 = " + sample.evaluate(-1.0));
            System.out.println("eval 0.3 = " + sample.evaluate(0.3));
            System.out.println("eval 1.0 = " + sample.evaluate(1.0));
            System.out.println("eval 1.1 = " + sample.evaluate(1.1));
            FunctionEvaluator shaper = new FunctionEvaluator();
            shaper.function.set(sample);
            this.synth.add(shaper);
            shaper.output.connect(0, this.lineOut.input, 0);
            shaper.output.connect(0, this.lineOut.input, 1);
            SineOscillator osc = new SineOscillator();
            osc.frequency.set(0.2);
            osc.output.connect(shaper.input);
            this.synth.add(osc);
            this.synth.start();
            this.lineOut.start();
            this.synth.sleepFor(5.0);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.synth.stop();
    }

    public static void main(String[] args) {
        new PlaySampleWaveShaper().test();
    }
}

