/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.softsynth.score.ScoreElement;
import com.softsynth.score.Sequence;
import com.syntona.model.music.DynamicIntonationTrackView;
import com.syntona.model.music.DynamicNote;
import com.syntona.model.music.DynamicTrack;
import com.syntona.model.music.TimeSelectionBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class DynamicIntonationEditor
extends JPanel {
    private static final long serialVersionUID = 6266577673544316174L;
    private Sequence sequence;
    private JPanel toolbar;
    private DynamicIntonationTrackView trackView;
    private TimeSelectionBar timeSelectionBar;
    private JRadioButton addButton;
    private JRadioButton selectButton;
    private JRadioButton relinkButton;

    public DynamicIntonationEditor(DynamicTrack sequence) {
        this.sequence = sequence;
        this.setLayout(new BorderLayout());
        this.toolbar = new JPanel();
        JPanel timeTrackPanel = new JPanel();
        timeTrackPanel.setLayout(new BorderLayout());
        this.trackView = new DynamicIntonationTrackView(sequence);
        this.trackView.setPreferredSize(new Dimension(8000, 1000));
        this.trackView.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int code = e.getKeyChar();
                code = Character.toUpperCase(code);
                switch (code) {
                    case 8: 
                    case 127: {
                        DynamicIntonationEditor.this.trackView.deleteSelectedNotes();
                        break;
                    }
                    case 65: {
                        DynamicIntonationEditor.this.addButton.doClick();
                        break;
                    }
                    case 83: {
                        DynamicIntonationEditor.this.selectButton.doClick();
                        break;
                    }
                    case 82: {
                        DynamicIntonationEditor.this.relinkButton.doClick();
                    }
                }
            }
        });
        this.trackView.setFocusable(true);
        this.trackView.requestFocusInWindow();
        this.timeSelectionBar = new TimeSelectionBar(this.trackView);
        JScrollPane timeScrollPane = new JScrollPane(timeTrackPanel, 21, 30);
        timeTrackPanel.add("North", this.timeSelectionBar);
        timeTrackPanel.add("Center", this.trackView);
        this.add("Center", timeScrollPane);
        this.add("North", this.toolbar);
        this.addToolSelector();
    }

    public void setDynamicTrack(DynamicTrack sequence) {
        this.sequence = sequence;
        this.trackView.setDynamicTrack(sequence);
    }

    private void addToolSelector() {
        ButtonGroup group = new ButtonGroup();
        this.addButton = this.addModeButton(group, "Add", DynamicIntonationTrackView.Mode.ADD);
        this.selectButton = this.addModeButton(group, "Select", DynamicIntonationTrackView.Mode.SELECT);
        this.relinkButton = this.addModeButton(group, "Relink", DynamicIntonationTrackView.Mode.RELINK);
    }

    private JRadioButton addModeButton(ButtonGroup group, String text, final DynamicIntonationTrackView.Mode mode) {
        JRadioButton modeButton = new JRadioButton(text);
        group.add(modeButton);
        this.toolbar.add(modeButton);
        modeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DynamicIntonationEditor.this.trackView.setMode(mode);
            }
        });
        modeButton.setSelected(this.trackView.getMode() == mode);
        return modeButton;
    }

    public void addToToolbar(Component component) {
        this.toolbar.add(component);
    }

    public DynamicNote[] getSelectedNotes() {
        return this.trackView.getSelectedNotes();
    }

    public void deleteSelectedNotes() {
        this.trackView.deleteSelectedNotes();
    }

    public void pasteNotes(DynamicNote[] noteArray) {
        this.trackView.pasteNotes(noteArray);
    }

    public double getStartOffset() {
        return this.timeSelectionBar.getStartOffset();
    }

    public double getStopOffset() {
        return this.timeSelectionBar.getStopOffset();
    }

    public void elementPlayed(ScoreElement element) {
        this.trackView.elementPlayed(element);
    }
}

