/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.gui.patch.GenericModuleView;
import com.syntona.gui.patch.ModuleEditor;
import com.syntona.gui.patch.ModuleView;
import com.syntona.model.music.BeatClockModule;
import com.syntona.plugin.GenericModulePresenter;
import com.syntona.plugin.Jack;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BeatClockModulePresenter
extends GenericModulePresenter {
    private BeatClockModule beatClockModule;
    private ModuleView moduleView = new GenericModuleView(this);

    public BeatClockModulePresenter() {
        super(new BeatClockModule());
        this.setView(this.moduleView);
        this.beatClockModule = (BeatClockModule)this.getModule();
    }

    @Override
    public ModuleEditor createModuleEditor() {
        return new BeatClockModuleEditor(this.getView());
    }

    private class BeatClockModuleEditor
    extends ModuleEditor
    implements PropertyChangeListener {
        private ButtonGroup cbg;

        public BeatClockModuleEditor(ModuleView moduleView) {
            super(moduleView);
        }

        @Override
        public Component setupJackEditors(ModuleView moduleView, Jack[] jacks) {
            byte[] divisors = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 12, 16};
            JPanel topPanel = new JPanel();
            System.out.println("BeatClockModuleEditor.setupJackEditors");
            topPanel.add(new JLabel("Enter clocks per beat:"));
            this.cbg = new ButtonGroup();
            Panel buttonPanel = new Panel();
            buttonPanel.setLayout(new GridLayout(2, 5));
            int currentDivisor = BeatClockModulePresenter.this.beatClockModule.getDivisor();
            topPanel.add(buttonPanel);
            byte[] byArray = divisors;
            int n = divisors.length;
            int n2 = 0;
            while (n2 < n) {
                byte n3 = byArray[n2];
                JRadioButton button = this.createDivisorButton(n3);
                buttonPanel.add(button);
                if (n3 == currentDivisor) {
                    button.setSelected(true);
                }
                ++n2;
            }
            return topPanel;
        }

        private JRadioButton createDivisorButton(final int divisor) {
            JRadioButton button = new JRadioButton("" + divisor);
            this.cbg.add(button);
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BeatClockModulePresenter.this.beatClockModule.setDivisor(divisor);
                }
            });
            return button;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            System.out.println("propertyChange in BeatClockModuleEditor");
        }
    }
}

