/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SyntonaPreferences {
    private static final String PROP_FILE_EXPORT = "file.export";
    private static final String PROP_FILE_SAVE = "file.save";
    private static final String PROP_FILE_LOAD = "file.load";
    private static final String PROP_WINDOW_XPOS = "window.xpos";
    private static final String PROP_WINDOW_YPOS = "window.ypos";
    private static final String PROP_WINDOW_WIDTH = "window.width";
    private static final String PROP_WINDOW_HEIGHT = "window.height";
    private static final String SYNTONA_DIR = "syntona";
    private static final String SOFTSYNTH_DIR = ".softsynth";
    private static final String PREFERENCES_FILE = "preferences.txt";
    private static SyntonaPreferences instance;
    private Properties props;

    public static SyntonaPreferences getInstance() {
        if (instance == null) {
            instance = new SyntonaPreferences();
            instance.load();
        }
        return instance;
    }

    public void load() {
        this.props = new Properties();
        File syntonaDir = this.getSyntonaDir();
        File preferencesFile = new File(syntonaDir, PREFERENCES_FILE);
        try {
            FileInputStream fileStream = new FileInputStream(preferencesFile);
            BufferedInputStream bufferedStream = new BufferedInputStream(fileStream);
            this.props.load(bufferedStream);
        }
        catch (IOException e) {
            System.out.println("Syntona Preferences file not found. One will be created on exit.");
        }
    }

    public Point getWindowLocation() {
        int x = this.getProperty(PROP_WINDOW_XPOS, 20);
        int y = this.getProperty(PROP_WINDOW_YPOS, 20);
        return new Point(x, y);
    }

    public Dimension getWindowSize() {
        int w = this.getProperty(PROP_WINDOW_WIDTH, 900);
        int h = this.getProperty(PROP_WINDOW_HEIGHT, 700);
        return new Dimension(w, h);
    }

    public void setLocation(Point location) {
        this.props.setProperty(PROP_WINDOW_XPOS, "" + location.x);
        this.props.setProperty(PROP_WINDOW_YPOS, "" + location.y);
    }

    public void setSize(Dimension size) {
        this.props.setProperty(PROP_WINDOW_WIDTH, "" + size.width);
        this.props.setProperty(PROP_WINDOW_HEIGHT, "" + size.height);
    }

    private int getProperty(String name, int defaultValue) {
        int value = defaultValue;
        String valueText = this.props.getProperty(name);
        if (valueText != null) {
            value = Integer.parseInt(valueText);
        }
        return value;
    }

    private File getSyntonaDir() {
        String userHome = System.getProperty("user.home");
        File userHomeDir = new File(userHome);
        File softsynthDir = new File(userHomeDir, SOFTSYNTH_DIR);
        File syntonaDir = new File(softsynthDir, SYNTONA_DIR);
        if (!syntonaDir.exists()) {
            syntonaDir.mkdirs();
        }
        return syntonaDir;
    }

    public void save() throws IOException {
        File syntonaDir = this.getSyntonaDir();
        File preferencesFile = new File(syntonaDir, PREFERENCES_FILE);
        FileOutputStream fileStream = new FileOutputStream(preferencesFile);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(fileStream);
        this.props.store(bufferedStream, "Preferences for Syntona. Do NOT edit by hand.");
    }

    public File getLastExportFile() {
        String path = this.props.getProperty(PROP_FILE_EXPORT, "Untitled.java");
        return new File(path);
    }

    public void setLastExportFile(File file) {
        this.props.setProperty(PROP_FILE_EXPORT, file.getAbsolutePath());
    }

    public File getLastSaveFile() {
        String path = this.props.getProperty(PROP_FILE_SAVE, "Untitled.xml");
        return new File(path);
    }

    public void setLastSaveFile(File file) {
        this.props.setProperty(PROP_FILE_SAVE, file.getAbsolutePath());
    }

    public File getLastLoadFile() {
        String path = this.props.getProperty(PROP_FILE_LOAD, ".");
        return new File(path);
    }

    public void setLastLoadFile(File file) {
        this.props.setProperty(PROP_FILE_LOAD, file.getAbsolutePath());
    }
}

