/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.IndentingWriter;
import com.softsynth.util.XMLListener;
import com.softsynth.util.XMLReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class XMLPrinter
extends IndentingWriter
implements XMLListener {
    public XMLPrinter() {
        this(System.out);
    }

    public XMLPrinter(OutputStream stream) {
        super(stream);
    }

    public static void main(String[] args) {
        String fileName = args.length > 0 ? args[0] : "xmlpatch.txt";
        try {
            File file = new File(fileName);
            System.out.println("File: " + file.getAbsolutePath());
            FileInputStream stream = new FileInputStream(file);
            XMLReader xmlr = new XMLReader(stream);
            xmlr.setXMLListener(new XMLPrinter());
            xmlr.parse();
            xmlr.close();
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            System.out.println("Error = " + e);
        }
        catch (SecurityException e) {
            System.out.println("Error = " + e);
        }
    }

    @Override
    public void beginElement(String tag, Hashtable attributes, boolean ifEmpty) {
        this.print("<" + tag);
        this.indent();
        Enumeration e = attributes.keys();
        if (e.hasMoreElements()) {
            this.println();
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)attributes.get(key);
            this.println(String.valueOf(key) + "=\"" + value + "\"");
        }
        if (ifEmpty) {
            this.undent();
            this.println("/>");
        } else {
            this.println(">");
        }
    }

    @Override
    public void foundContent(String content) {
        if (content != null) {
            this.println(content);
        }
    }

    @Override
    public void endElement(String tag) {
        this.undent();
        this.println("</" + tag + ">");
    }
}

