/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.softsynth.math.FourierMath;
import junit.framework.TestCase;

public class TestFFT
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void checkSingleSineDouble(int size, int bin) {
        double[] ar = new double[size];
        double[] ai = new double[size];
        double[] magnitudes = new double[size];
        double amplitude = 1.0;
        this.addSineWave(size, bin, ar, amplitude);
        FourierMath.transform(1, size, ar, ai);
        FourierMath.calculateMagnitudes(ar, ai, magnitudes);
        TestFFT.assertEquals("magnitude", 0.0, magnitudes[bin - 1], 1.0E-6);
        TestFFT.assertEquals("magnitude", amplitude, magnitudes[bin], 1.0E-6);
        TestFFT.assertEquals("magnitude", 0.0, magnitudes[bin + 1], 1.0E-6);
    }

    public void checkSingleSineFloat(int size, int bin) {
        float[] ar = new float[size];
        float[] ai = new float[size];
        float[] magnitudes = new float[size];
        double amplitude = 1.0;
        this.addSineWave(size, bin, ar, amplitude);
        FourierMath.transform(1, size, ar, ai);
        FourierMath.calculateMagnitudes(ar, ai, magnitudes);
        TestFFT.assertEquals("magnitude", 0.0, (double)magnitudes[bin - 1], 1.0E-6);
        TestFFT.assertEquals("magnitude", amplitude, (double)magnitudes[bin], 1.0E-6);
        TestFFT.assertEquals("magnitude", 0.0, (double)magnitudes[bin + 1], 1.0E-6);
    }

    public void checkMultipleSine(int size, int[] bins, double[] amplitudes) {
        double[] ar = new double[size];
        double[] ai = new double[size];
        double[] magnitudes = new double[size];
        int i = 0;
        while (i < bins.length) {
            this.addSineWave(size, bins[i], ar, amplitudes[i]);
            ++i;
        }
        FourierMath.transform(1, size, ar, ai);
        FourierMath.calculateMagnitudes(ar, ai, magnitudes);
        int bin = 0;
        while (bin < size) {
            System.out.printf("%d = %9.7f\n", bin, magnitudes[bin]);
            double amplitude = 0.0;
            int i2 = 0;
            while (i2 < bins.length) {
                if (bin == bins[i2] || bin == size - bins[i2]) {
                    amplitude = amplitudes[i2];
                    break;
                }
                ++i2;
            }
            TestFFT.assertEquals("magnitude", amplitude, magnitudes[bin], 1.0E-6);
            ++bin;
        }
    }

    private void addSineWave(int size, int bin, double[] ar, double amplitude) {
        double phase = 0.0;
        double phaseIncrement = Math.PI * 2 * (double)bin / (double)size;
        int i = 0;
        while (i < size) {
            int n = i++;
            ar[n] = ar[n] + Math.sin(phase) * amplitude;
            phase += phaseIncrement;
        }
    }

    private void addSineWave(int size, int bin, float[] ar, double amplitude) {
        double phase = 0.0;
        double phaseIncrement = Math.PI * 2 * (double)bin / (double)size;
        int i = 0;
        while (i < size) {
            int n = i++;
            ar[n] = ar[n] + (float)(Math.sin(phase) * amplitude);
            phase += phaseIncrement;
        }
    }

    public void testSinglesDouble() {
        this.checkSingleSineDouble(32, 1);
        this.checkSingleSineDouble(32, 4);
        this.checkSingleSineDouble(64, 5);
        this.checkSingleSineDouble(256, 3);
    }

    public void testSinglesFloat() {
        this.checkSingleSineFloat(32, 1);
        this.checkSingleSineFloat(32, 4);
        this.checkSingleSineFloat(64, 5);
        this.checkSingleSineFloat(256, 3);
    }

    public void testMultipleSines32() {
        int[] bins = new int[]{1, 5};
        double[] amplitudes = new double[]{1.0, 2.0};
        this.checkMultipleSine(32, bins, amplitudes);
    }

    public void testMultipleSines64() {
        int[] bins = new int[]{2, 4, 7};
        double[] amplitudes = new double[]{1.0, 0.3, 0.5};
        this.checkMultipleSine(64, bins, amplitudes);
    }

    public void checkInverseFftDouble(int size, int bin) {
        double[] ar1 = new double[size];
        double[] ai1 = new double[size];
        double[] ar2 = new double[size];
        double[] ai2 = new double[size];
        double amplitude = 1.0;
        this.addSineWave(size, bin, ar1, amplitude);
        System.arraycopy(ar1, 0, ar2, 0, size);
        System.arraycopy(ai1, 0, ai2, 0, size);
        FourierMath.transform(1, size, ar1, ai1);
        FourierMath.transform(-1, size, ar1, ai1);
        int i = 0;
        while (i < size) {
            TestFFT.assertEquals(ar2[i], ar1[i], 1.0E-5);
            TestFFT.assertEquals(ai2[i], ai1[i], 1.0E-5);
            ++i;
        }
    }

    public void checkInverseFftFloat(int size, int bin) {
        float[] ar1 = new float[size];
        float[] ai1 = new float[size];
        float[] ar2 = new float[size];
        float[] ai2 = new float[size];
        double amplitude = 1.0;
        this.addSineWave(size, bin, ar1, amplitude);
        System.arraycopy(ar1, 0, ar2, 0, size);
        System.arraycopy(ai1, 0, ai2, 0, size);
        FourierMath.transform(1, size, ar1, ai1);
        FourierMath.transform(-1, size, ar1, ai1);
        int i = 0;
        while (i < size) {
            TestFFT.assertEquals((double)ar2[i], (double)ar1[i], 1.0E-5);
            TestFFT.assertEquals((double)ai2[i], (double)ai1[i], 1.0E-5);
            ++i;
        }
    }

    public void testInverseDouble() {
        this.checkInverseFftDouble(32, 1);
        this.checkInverseFftDouble(32, 2);
        this.checkInverseFftDouble(128, 17);
        this.checkInverseFftDouble(512, 23);
    }

    public void testInverseFloat() {
        this.checkInverseFftFloat(32, 1);
        this.checkInverseFftFloat(32, 2);
        this.checkInverseFftFloat(128, 17);
        this.checkInverseFftFloat(512, 23);
    }
}

