/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.VariableRateDataReader;

public class VariableRateStereoReader
extends VariableRateDataReader {
    private double phase;
    private double baseIncrement;
    private double source0;
    private double current0;
    private double target0;
    private double source1;
    private double current1;
    private double target1;
    private boolean starved;
    private boolean ranout;

    public VariableRateStereoReader() {
        this.dataQueue.setNumChannels(2);
        this.output = new UnitOutputPort(2, "Output");
        this.addPort(this.output);
        this.starved = true;
        this.baseIncrement = 1.0;
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues();
        double[] rates = this.rate.getValues();
        double[] output0s = this.output.getValues(0);
        double[] output1s = this.output.getValues(1);
        int i = start;
        while (i < limit) {
            if (this.phase >= 1.0) {
                while (this.phase >= 1.0) {
                    this.source0 = this.target0;
                    this.source1 = this.target1;
                    this.phase -= 1.0;
                    this.baseIncrement = this.advanceToNextFrame();
                }
            } else if (i == 0 && (this.starved || !this.dataQueue.isTargetValid())) {
                this.source0 = this.target0 = this.current0;
                this.source1 = this.target1 = this.current1;
                this.phase = 0.0;
                this.baseIncrement = this.advanceToNextFrame();
            }
            this.current0 = (this.target0 - this.source0) * this.phase + this.source0;
            output0s[i] = this.current0 * amplitudes[i];
            this.current1 = (this.target1 - this.source1) * this.phase + this.source1;
            output1s[i] = this.current1 * amplitudes[i];
            double phaseIncrement = this.baseIncrement * rates[i];
            this.phase += this.limitPhaseIncrement(phaseIncrement);
            ++i;
        }
        if (this.ranout) {
            this.ranout = false;
            if (this.dataQueue.testAndClearAutoStop()) {
                this.autoStop();
            }
        }
    }

    public double limitPhaseIncrement(double phaseIncrement) {
        return phaseIncrement;
    }

    private double advanceToNextFrame() {
        this.dataQueue.firePendingCallbacks();
        if (this.dataQueue.hasMore()) {
            this.starved = false;
            this.dataQueue.beginFrame(this.getFramePeriod());
            this.target0 = this.dataQueue.readCurrentChannelDouble(0);
            this.target1 = this.dataQueue.readCurrentChannelDouble(1);
            this.dataQueue.endFrame();
            return this.synthesisEngine.getFramePeriod() * this.dataQueue.getNormalizedRate();
        }
        this.starved = true;
        this.ranout = true;
        this.phase = 0.0;
        return 0.0;
    }
}

