/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.ContinuousRamp;
import com.jsyn.unitgen.ExponentialRamp;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.NonRealTimeTestCase;
import com.jsyn.unitgen.PassThrough;

public class TestRamps
extends NonRealTimeTestCase {
    public void viewContinuousRamp(double duration, double startValue, double targetValue) throws InterruptedException {
        ContinuousRamp ramp = new ContinuousRamp();
        this.synthesisEngine.add(ramp);
        ramp.current.set(startValue);
        ramp.input.set(startValue);
        ramp.time.set(duration);
        this.synthesisEngine.setRealTime(false);
        this.synthesisEngine.start();
        ramp.start();
        this.synthesisEngine.sleepUntil(this.synthesisEngine.getCurrentTime() + 0.01);
        ramp.input.set(targetValue);
        double time = this.synthesisEngine.getCurrentTime();
        int numLoops = 20;
        double increment = duration / (double)numLoops;
        int i = 0;
        while (i < numLoops + 1) {
            double value = ramp.output.getValue();
            System.out.printf("i = %d, t = %9.5f,  value = %8.4f\n", i, time, value);
            this.synthesisEngine.sleepUntil(time += increment);
            ++i;
        }
        this.synthesisEngine.stop();
    }

    public void checkContinuousRamp(double duration, double startValue, double targetValue) throws InterruptedException {
        ContinuousRamp ramp = new ContinuousRamp();
        this.synthesisEngine.add(ramp);
        ramp.current.set(startValue);
        ramp.input.set(startValue);
        ramp.time.set(duration);
        this.synthesisEngine.setRealTime(false);
        this.synthesisEngine.start();
        ramp.start();
        this.synthesisEngine.sleepUntil(this.synthesisEngine.getCurrentTime() + 0.01);
        TestRamps.assertEquals("start flat", (Object)ramp.input.getValue(), (Object)ramp.output.getValue());
        ramp.input.set(targetValue);
        double startTime = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(startTime + duration / 2.0);
        TestRamps.assertEquals("ramping up", (targetValue + startValue) / 2.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + duration);
        TestRamps.assertEquals("ramping up", targetValue, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + duration + 0.1);
        TestRamps.assertEquals("flat again", (Object)targetValue, (Object)ramp.output.getValue());
        this.synthesisEngine.stop();
    }

    public void testContinuousRamp() throws InterruptedException {
        this.viewContinuousRamp(4.0, 0.0, 1.0);
    }

    public void testExponentialRamp() throws InterruptedException {
        ExponentialRamp ramp = new ExponentialRamp();
        this.synthesisEngine.add(ramp);
        double duration = 0.3;
        ramp.current.set(1.0);
        ramp.input.set(1.0);
        ramp.time.set(duration);
        this.synthesisEngine.start();
        ramp.start();
        this.synthesisEngine.sleepUntil(this.synthesisEngine.getCurrentTime() + 0.01);
        TestRamps.assertEquals("start flat", (Object)ramp.input.getValue(), (Object)ramp.output.getValue());
        ramp.input.set(8.0);
        double startTime = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(startTime + 0.1);
        TestRamps.assertEquals("ramping up", 2.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.2);
        TestRamps.assertEquals("ramping up", 4.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.3);
        TestRamps.assertEquals("ramping up", 8.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.4);
        TestRamps.assertEquals("flat again", (Object)8.0, (Object)ramp.output.getValue());
    }

    public void testLinearRamp() throws InterruptedException {
        LinearRamp ramp = new LinearRamp();
        this.synthesisEngine.add(ramp);
        double duration = 0.4;
        ramp.current.set(0.0);
        ramp.input.set(0.0);
        ramp.time.set(duration);
        this.synthesisEngine.start();
        ramp.start();
        this.synthesisEngine.sleepUntil(this.synthesisEngine.getCurrentTime() + 0.01);
        TestRamps.assertEquals("start flat", (Object)ramp.input.getValue(), (Object)ramp.output.getValue());
        ramp.input.set(8.0);
        double startTime = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(startTime + 0.1);
        TestRamps.assertEquals("ramping up", 2.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.2);
        TestRamps.assertEquals("ramping up", 4.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.3);
        TestRamps.assertEquals("ramping up", 6.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.4);
        TestRamps.assertEquals("flat again", (Object)8.0, (Object)ramp.output.getValue());
    }

    public void testExponentialRampConnected() throws InterruptedException {
        ExponentialRamp ramp = new ExponentialRamp();
        PassThrough pass = new PassThrough();
        this.synthesisEngine.add(ramp);
        this.synthesisEngine.add(pass);
        double duration = 0.3;
        ramp.current.set(1.0);
        pass.input.set(1.0);
        ramp.time.set(duration);
        pass.input.set(1.0);
        pass.output.connect(ramp.input);
        this.synthesisEngine.start();
        ramp.start();
        this.synthesisEngine.sleepUntil(this.synthesisEngine.getCurrentTime() + 0.01);
        TestRamps.assertEquals("start flat", (Object)ramp.input.getValue(), (Object)ramp.output.getValue());
        pass.input.set(8.0);
        double startTime = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(startTime + 0.1);
        TestRamps.assertEquals("ramping up", 2.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.2);
        TestRamps.assertEquals("ramping up", 4.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.3);
        TestRamps.assertEquals("ramping up", 8.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.4);
        TestRamps.assertEquals("flat again", (Object)8.0, (Object)ramp.output.getValue());
    }

    public void testLinearRampConnected() throws InterruptedException {
        LinearRamp ramp = new LinearRamp();
        PassThrough pass = new PassThrough();
        this.synthesisEngine.add(ramp);
        this.synthesisEngine.add(pass);
        double duration = 0.4;
        ramp.current.set(0.0);
        pass.input.set(0.0);
        ramp.time.set(duration);
        pass.input.set(0.0);
        pass.output.connect(ramp.input);
        this.synthesisEngine.start();
        ramp.start();
        this.synthesisEngine.sleepUntil(this.synthesisEngine.getCurrentTime() + 0.01);
        TestRamps.assertEquals("start flat", (Object)ramp.input.getValue(), (Object)ramp.output.getValue());
        pass.input.set(8.0);
        double startTime = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(startTime + 0.1);
        TestRamps.assertEquals("ramping up", 2.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.2);
        TestRamps.assertEquals("ramping up", 4.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.3);
        TestRamps.assertEquals("ramping up", 6.0, ramp.output.getValue(), 0.01);
        this.synthesisEngine.sleepUntil(startTime + 0.4);
        TestRamps.assertEquals("flat again", (Object)8.0, (Object)ramp.output.getValue());
    }
}

