/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Grain;
import com.jsyn.unitgen.GrainScheduler;
import com.jsyn.unitgen.GrainSourceSine;
import com.jsyn.unitgen.RaisedCosineEnvelope;
import com.jsyn.unitgen.StochasticGrainScheduler;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.util.PseudoRandom;

public class GrainFarm
extends UnitGenerator
implements UnitSource {
    public UnitInputPort rate;
    public UnitInputPort rateRange;
    public UnitInputPort amplitude;
    public UnitInputPort amplitudeRange;
    public UnitInputPort density;
    public UnitInputPort duration;
    public UnitInputPort durationRange;
    public UnitOutputPort output;
    PseudoRandom randomizer;
    private GrainState[] states;
    private double countScaler = 1.0;
    private final GrainScheduler scheduler = new StochasticGrainScheduler();

    public GrainFarm() {
        this.randomizer = new PseudoRandom();
        this.rate = new UnitInputPort("Rate", 1.0);
        this.addPort(this.rate);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.duration = new UnitInputPort("Duration", 0.01);
        this.addPort(this.duration);
        this.rateRange = new UnitInputPort("RateRange", 0.0);
        this.addPort(this.rateRange);
        this.amplitudeRange = new UnitInputPort("AmplitudeRange", 0.0);
        this.addPort(this.amplitudeRange);
        this.durationRange = new UnitInputPort("DurationRange", 0.0);
        this.addPort(this.durationRange);
        this.density = new UnitInputPort("Density", 0.1);
        this.addPort(this.density);
        this.output = new UnitOutputPort();
        this.addPort(this.output);
    }

    public void setGrainArray(Grain[] grains) {
        this.countScaler = 1.0 / (double)grains.length;
        this.states = new GrainState[grains.length];
        int i = 0;
        while (i < this.states.length) {
            this.states[i] = new GrainState();
            this.states[i].grain = grains[i];
            grains[i].setFrameRate(this.getSynthesisEngine().getFrameRate());
            ++i;
        }
    }

    public void setupGrain(Grain grain, int i) {
        double temp = this.rate.getValues()[i] * this.calculateOctaveScaler(this.rateRange.getValues()[i]);
        grain.setRate(temp);
        double base = this.amplitude.getValues()[i];
        double offset = base * Math.random() * this.amplitudeRange.getValues()[i];
        grain.setAmplitude(base - offset);
    }

    public void allocate(int numGrains) {
        Grain[] grainArray = new Grain[numGrains];
        int i = 0;
        while (i < numGrains) {
            Grain grain;
            grainArray[i] = grain = new Grain(new GrainSourceSine(), new RaisedCosineEnvelope());
            ++i;
        }
        this.setGrainArray(grainArray);
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }

    private double calculateOctaveScaler(double rangeValue) {
        double octaveRange = 0.5 * this.randomizer.nextRandomDouble() * rangeValue;
        return Math.pow(2.0, octaveRange);
    }

    @Override
    public void generate(int start, int limit) {
        double[] outputs = this.output.getValues();
        double[] amplitudes = this.amplitude.getValues();
        int i = start;
        while (i < limit) {
            double result = 0.0;
            GrainState[] grainStateArray = this.states;
            int n = this.states.length;
            int n2 = 0;
            while (n2 < n) {
                GrainState grainState = grainStateArray[n2];
                result += grainState.next(i);
                ++n2;
            }
            outputs[i] = result * amplitudes[i] * this.countScaler;
            ++i;
        }
    }

    private class GrainState {
        Grain grain;
        int countdown;
        double lastDuration;
        static final int STATE_IDLE = 0;
        static final int STATE_GAP = 1;
        static final int STATE_RUNNING = 2;
        int state = 0;
        private double gapError;

        private GrainState() {
        }

        public double next(int i) {
            double output = 0.0;
            if (this.state == 2) {
                if (this.grain.hasMoreValues()) {
                    output = this.grain.next();
                } else {
                    this.startGap(i);
                }
            } else if (this.state == 1) {
                if (this.countdown > 0) {
                    --this.countdown;
                } else if (this.countdown == 0) {
                    this.state = 2;
                    this.grain.reset();
                    GrainFarm.this.setupGrain(this.grain, i);
                    double dur = this.nextDuration(i);
                    this.grain.setDuration(dur);
                }
            } else if (this.state == 0) {
                this.nextDuration(i);
                this.startGap(i);
            }
            return output;
        }

        private double nextDuration(int i) {
            double dur = GrainFarm.this.duration.getValues()[i];
            this.lastDuration = dur = GrainFarm.this.scheduler.nextDuration(dur);
            return dur;
        }

        private void startGap(int i) {
            this.state = 1;
            double dens = GrainFarm.this.density.getValues()[i];
            double gap = GrainFarm.this.scheduler.nextGap(this.lastDuration, dens) * (double)GrainFarm.this.getFrameRate();
            this.countdown = (int)(gap += this.gapError);
            this.gapError = gap - (double)this.countdown;
        }
    }
}

