/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.math.FourierMath;

public abstract class FFTBase
extends UnitGenerator {
    public UnitInputPort inputReal = new UnitInputPort("InputReal");
    public UnitInputPort inputImaginary;
    public UnitOutputPort outputReal;
    public UnitOutputPort outputImaginary;
    protected double[] realInput;
    protected double[] realOutput;
    protected double[] imaginaryInput;
    protected double[] imaginaryOutput;
    protected int cursor;

    protected FFTBase() {
        this.addPort(this.inputReal);
        this.inputImaginary = new UnitInputPort("InputImaginary");
        this.addPort(this.inputImaginary);
        this.outputReal = new UnitOutputPort("OutputReal");
        this.addPort(this.outputReal);
        this.outputImaginary = new UnitOutputPort("OutputImaginary");
        this.addPort(this.outputImaginary);
        this.setSize(512);
    }

    public void setSize(int size) {
        this.realInput = new double[size];
        this.realOutput = new double[size];
        this.imaginaryInput = new double[size];
        this.imaginaryOutput = new double[size];
        this.cursor = 0;
    }

    public int getSize() {
        return this.realInput.length;
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputRs = this.inputReal.getValues();
        double[] inputIs = this.inputImaginary.getValues();
        double[] outputRs = this.outputReal.getValues();
        double[] outputIs = this.outputImaginary.getValues();
        int i = start;
        while (i < limit) {
            this.realInput[this.cursor] = inputRs[i];
            this.imaginaryInput[this.cursor] = inputIs[i];
            outputRs[i] = this.realOutput[this.cursor];
            outputIs[i] = this.imaginaryOutput[this.cursor];
            ++this.cursor;
            if (this.cursor == this.realInput.length) {
                System.arraycopy(this.realInput, 0, this.realOutput, 0, this.realInput.length);
                System.arraycopy(this.imaginaryInput, 0, this.imaginaryOutput, 0, this.imaginaryInput.length);
                FourierMath.transform(this.getSign(), this.realOutput.length, this.realOutput, this.imaginaryOutput);
                this.cursor = 0;
            }
            ++i;
        }
    }

    protected abstract int getSign();
}

