/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.UnitGate;
import com.jsyn.unitgen.UnitSource;

public class EnvelopeDAHDSR
extends UnitGate
implements UnitSource {
    private static final double MIN_DURATION = 1.0E-5;
    public UnitInputPort delay;
    public UnitInputPort attack;
    public UnitInputPort hold;
    public UnitInputPort decay;
    public UnitInputPort sustain;
    public UnitInputPort release;
    public UnitInputPort amplitude;
    private State state = State.IDLE;
    private double countdown;
    private double scaler = 1.0;
    private double level;
    private double increment;

    public EnvelopeDAHDSR() {
        this.delay = new UnitInputPort("Delay", 0.0);
        this.addPort(this.delay);
        this.delay.setup(0.0, 0.0, 2.0);
        this.attack = new UnitInputPort("Attack", 0.1);
        this.addPort(this.attack);
        this.attack.setup(0.01, 0.1, 8.0);
        this.hold = new UnitInputPort("Hold", 0.0);
        this.addPort(this.hold);
        this.hold.setup(0.0, 0.0, 2.0);
        this.decay = new UnitInputPort("Decay", 0.2);
        this.addPort(this.decay);
        this.decay.setup(0.01, 0.2, 8.0);
        this.sustain = new UnitInputPort("Sustain", 0.5);
        this.addPort(this.sustain);
        this.sustain.setup(0.0, 0.5, 1.0);
        this.release = new UnitInputPort("Release", 0.3);
        this.addPort(this.release);
        this.release.setup(0.01, 0.3, 8.0);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
    }

    @Override
    public void generate(int start, int limit) {
        double[] sustains = this.sustain.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        int i = start;
        block9: while (i < limit) {
            boolean triggered = this.input.checkGate(i);
            block0 : switch (this.state) {
                case IDLE: {
                    while (i < limit) {
                        outputs[i] = this.level * amplitudes[i];
                        if (triggered) {
                            this.startDelay(i);
                            break block0;
                        }
                        ++i;
                    }
                    continue block9;
                }
                case DELAYING: {
                    while (i < limit) {
                        outputs[i] = this.level * amplitudes[i];
                        if (this.input.isOff()) {
                            this.startRelease(i);
                            break block0;
                        }
                        this.countdown -= 1.0;
                        if (this.countdown <= 0.0) {
                            this.startAttack(i);
                            break block0;
                        }
                        ++i;
                    }
                    continue block9;
                }
                case ATTACKING: {
                    while (i < limit) {
                        this.level += this.increment;
                        if (this.level >= 1.0) {
                            this.level = 1.0;
                            outputs[i] = this.level * amplitudes[i];
                            this.startHold(i);
                            break block0;
                        }
                        outputs[i] = this.level * amplitudes[i];
                        if (this.input.isOff()) {
                            this.startRelease(i);
                            break block0;
                        }
                        ++i;
                    }
                    continue block9;
                }
                case HOLDING: {
                    while (i < limit) {
                        outputs[i] = amplitudes[i];
                        this.countdown -= 1.0;
                        if (this.countdown <= 0.0) {
                            this.startDecay(i);
                            break block0;
                        }
                        if (this.input.isOff()) {
                            this.startRelease(i);
                            break block0;
                        }
                        ++i;
                    }
                    continue block9;
                }
                case DECAYING: {
                    while (i < limit) {
                        outputs[i] = this.level * amplitudes[i];
                        this.level *= this.scaler;
                        if (triggered) {
                            this.startDelay(i);
                            break block0;
                        }
                        if (this.level < sustains[i]) {
                            this.level = sustains[i];
                            this.startSustain(i);
                            break block0;
                        }
                        if (this.level < 1.5848931924611107E-5) {
                            this.input.checkAutoDisable();
                            this.startIdle();
                            break block0;
                        }
                        if (this.input.isOff()) {
                            this.startRelease(i);
                            break block0;
                        }
                        ++i;
                    }
                    continue block9;
                }
                case SUSTAINING: {
                    while (i < limit) {
                        this.level = sustains[i];
                        outputs[i] = this.level * amplitudes[i];
                        if (triggered) {
                            this.startDelay(i);
                            break block0;
                        }
                        if (this.input.isOff()) {
                            this.startRelease(i);
                            break block0;
                        }
                        ++i;
                    }
                    continue block9;
                }
                case RELEASING: {
                    while (i < limit) {
                        outputs[i] = this.level * amplitudes[i];
                        this.level *= this.scaler;
                        if (triggered) {
                            this.startDelay(i);
                            break block0;
                        }
                        if (this.level < 1.5848931924611107E-5) {
                            this.input.checkAutoDisable();
                            this.startIdle();
                            break block0;
                        }
                        ++i;
                    }
                    continue block9;
                }
            }
        }
    }

    private void startIdle() {
        this.state = State.IDLE;
        this.level = 0.0;
    }

    private void startDelay(int i) {
        double[] delays = this.delay.getValues();
        if (delays[i] <= 0.0) {
            this.startAttack(i);
        } else {
            this.countdown = (int)(delays[i] * (double)this.getFrameRate());
            this.state = State.DELAYING;
        }
    }

    private void startAttack(int i) {
        double[] attacks = this.attack.getValues();
        double duration = attacks[i];
        if (duration < 1.0E-5) {
            this.level = 1.0;
            this.startHold(i);
        } else {
            this.increment = this.getFramePeriod() / duration;
            this.state = State.ATTACKING;
        }
    }

    private void startHold(int i) {
        double[] holds = this.hold.getValues();
        if (holds[i] <= 0.0) {
            this.startDecay(i);
        } else {
            this.countdown = (int)(holds[i] * (double)this.getFrameRate());
            this.state = State.HOLDING;
        }
    }

    private void startDecay(int i) {
        double[] decays = this.decay.getValues();
        double duration = decays[i];
        if (duration < 1.0E-5) {
            this.startSustain(i);
        } else {
            this.scaler = this.getSynthesisEngine().convertTimeToExponentialScaler(duration);
            this.state = State.DECAYING;
        }
    }

    private void startSustain(int i) {
        this.state = State.SUSTAINING;
    }

    private void startRelease(int i) {
        double[] releases = this.release.getValues();
        double duration = releases[i];
        if (duration < 1.0E-5) {
            duration = 1.0E-5;
        }
        this.scaler = this.getSynthesisEngine().convertTimeToExponentialScaler(duration);
        this.state = State.RELEASING;
    }

    public void export(Circuit circuit, String prefix) {
        circuit.addPort(this.attack, String.valueOf(prefix) + this.attack.getName());
        circuit.addPort(this.decay, String.valueOf(prefix) + this.decay.getName());
        circuit.addPort(this.sustain, String.valueOf(prefix) + this.sustain.getName());
        circuit.addPort(this.release, String.valueOf(prefix) + this.release.getName());
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }

    static enum State {
        IDLE,
        DELAYING,
        ATTACKING,
        HOLDING,
        DECAYING,
        SUSTAINING,
        RELEASING;

    }
}

