/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.Minimum;
import junit.framework.TestCase;

public class TestSet
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSetValue() {
        int numParts = 4;
        UnitInputPort port = new UnitInputPort(numParts, "Tester");
        port.setValueInternal(0, 100.0);
        port.setValueInternal(2, 120.0);
        port.setValueInternal(1, 110.0);
        port.setValueInternal(3, 130.0);
        TestSet.assertEquals("check port value", (Object)100.0, (Object)port.getValue(0));
        TestSet.assertEquals("check port value", (Object)120.0, (Object)port.getValue(2));
        TestSet.assertEquals("check port value", (Object)110.0, (Object)port.getValue(1));
        TestSet.assertEquals("check port value", (Object)130.0, (Object)port.getValue(3));
    }

    public void testSet() throws InterruptedException {
        SynthesisEngine synthesisEngine = new SynthesisEngine();
        synthesisEngine.setRealTime(false);
        synthesisEngine.start();
        synthesisEngine.sleepUntil(0.01);
        Minimum min = new Minimum();
        synthesisEngine.add(min);
        double x = 33.99;
        double y = 8.31;
        min.inputA.set(x);
        min.inputB.set(y);
        synthesisEngine.sleepFor(0.01);
        TestSet.assertEquals("min set A", (Object)x, (Object)min.inputA.getValue());
        TestSet.assertEquals("min set B", (Object)y, (Object)min.inputB.getValue());
        min.start();
        synthesisEngine.sleepFor(0.01);
        TestSet.assertEquals("min output", (Object)y, (Object)min.output.getValue());
        synthesisEngine.stop();
    }

    public void testSetBadPort() throws InterruptedException {
        SynthesisEngine synthesisEngine = new SynthesisEngine();
        synthesisEngine.setRealTime(false);
        synthesisEngine.start();
        Minimum min = new Minimum();
        synthesisEngine.add(min);
        min.start();
        Exception caught = null;
        try {
            min.inputA.set(1, 23.45);
        }
        catch (Exception e) {
            caught = e;
        }
        TestSet.assertTrue("Catch port out of range, caught " + caught, caught instanceof ArrayIndexOutOfBoundsException);
        synthesisEngine.sleepUntil(0.01);
        synthesisEngine.stop();
    }
}

