/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.view11x.XYController;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class XYTheremin
extends XYController {
    SynthOscillator osc;
    ExponentialLag freqLag;
    ExponentialLag ampLag;
    private static final double LOW_PITCH = 36.0;
    private static final double HIGH_PITCH = 96.0;
    double pitch = 66.0;
    double amplitude = 0.0;
    private static final int OVAL_SIZE = 10;

    public XYTheremin(SynthOscillator osc) {
        this.osc = osc;
        this.setSize(100, 100);
        this.freqLag = new ExponentialLag();
        this.ampLag = new ExponentialLag();
        this.freqLag.output.connect(osc.frequency);
        this.ampLag.output.connect(osc.amplitude);
        this.setMinWorldX(36.0);
        this.setMaxWorldX(96.0);
        this.setMinWorldY(-0.1);
        this.setMaxWorldY(1.0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                XYTheremin.this.extractParameters(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                XYTheremin.this.extractParameters(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                XYTheremin.this.extractParameters(e);
            }
        });
        this.updateSound();
        this.repaint();
    }

    public void start() {
        this.freqLag.start();
        this.ampLag.start();
    }

    public void stop() {
        this.freqLag.stop();
        this.ampLag.stop();
    }

    private void extractParameters(MouseEvent e) {
        this.pitch = this.convertGXtoWX(e.getX());
        double amp = this.convertGYtoWY(e.getY());
        this.amplitude = this.clipWorldY(amp);
        this.updateSound();
        this.repaint();
    }

    private void updateSound() {
        double frequency = EqualTemperedTuning.getMIDIFrequency(this.pitch);
        this.freqLag.input.set(frequency);
        double oscAmp = this.amplitude;
        if (oscAmp < 0.0) {
            oscAmp = 0.0;
        } else if (oscAmp > 1.0) {
            oscAmp = 1.0;
        }
        this.ampLag.input.set(oscAmp);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getForeground());
        int x = this.convertWXtoGX(this.pitch);
        int y = this.convertWYtoGY(this.amplitude);
        g.fillOval(x - 5, y - 5, 10, 10);
    }
}

