/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import compmus.Samples;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;

class SamplesView
extends Canvas {
    private int sampleStart;
    private int sampleBase;
    private int sampleWidth;
    private int sampleRadius;
    private double sampleScale;
    private double sampleValue;
    private int lastDrag;
    int width;
    int height;
    public Samples samples;

    public SamplesView(Samples s) {
        this.samples = s;
        this.setSampleValue(1.0);
        this.updateDrawingSizes();
    }

    public void setSampleValue(double v) {
        int height = this.size().height;
        this.sampleValue = v != 0.0 ? v : 1.0;
        this.sampleScale = (double)(-0.25f * (float)height) / this.sampleValue;
    }

    @Override
    public void paint(Graphics g) {
        this.updateDrawingSizes();
        this.drawSamples(g);
    }

    @Override
    public Dimension minimumSize() {
        return new Dimension(100, 50);
    }

    @Override
    public Dimension preferredSize() {
        return this.minimumSize();
    }

    @Override
    public boolean mouseDown(Event e, int x, int y) {
        this.lastDrag = -1;
        return this.mouseDrag(e, x, y);
    }

    @Override
    public boolean mouseDrag(Event e, int x, int y) {
        if (x < 0 || x > this.size().width) {
            return true;
        }
        if (y < this.sampleRadius || y > this.size().height - this.sampleRadius) {
            return true;
        }
        int i = (int)((double)(x - this.sampleStart) / (double)this.sampleWidth + 0.5);
        if (i < 0) {
            i = 0;
        }
        if (i >= this.samples.values.length) {
            i = this.samples.values.length - 1;
        }
        Graphics g = this.getGraphics();
        g.setColor(this.getBackground());
        this.drawOneSample(g, i);
        this.samples.values[i] = (double)(y - this.sampleBase) / this.sampleScale;
        g.setColor(this.getForeground());
        this.drawOneSample(g, i);
        this.lastDrag = i;
        this.samples.notifyObservers();
        return true;
    }

    @Override
    public boolean mouseUp(Event e, int x, int y) {
        this.samples.notifyObservers();
        return true;
    }

    private void drawOneSample(Graphics g, int i) {
        int x = this.sampleStart + i * this.sampleWidth;
        int y = this.sampleBase;
        int w = this.sampleWidth;
        int h = (int)(this.samples.values[i] * this.sampleScale);
        g.drawLine(x, y, x, y + h);
    }

    private void drawSamples(Graphics g) {
        g.drawRect(0, 0, this.width - 1, this.height - 1);
        int i = 0;
        while (i < this.samples.values.length) {
            this.drawOneSample(g, i);
            ++i;
        }
    }

    private void updateDrawingSizes() {
        this.width = this.size().width;
        this.height = this.size().height;
        int nSamples = this.samples.values.length;
        this.sampleWidth = (int)((double)this.width / (double)(nSamples + 1));
        this.sampleStart = (this.width - (nSamples - 1) * this.sampleWidth) / 2;
        this.sampleBase = (int)(0.5f * (float)this.height);
        this.sampleScale = (double)(-0.25f * (float)this.height) / this.sampleValue;
    }
}

