/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.util.BussedVoiceAllocator;
import compmus.Melody;

public class MelodyPlayer
implements Runnable {
    static final int maxNumVoices = 2;
    public BussedVoiceAllocator allocator;
    Melody melody;
    public EqualTemperedTuning tuning = new EqualTemperedTuning(200.0);
    boolean die = false;
    boolean play = true;
    boolean loop = false;
    Thread thread;
    private double secondsPerUnitDuration = 0.2;

    public MelodyPlayer() {
        this.makeAllocator();
    }

    void makeAllocator() {
        this.allocator = new BussedVoiceAllocator(2){

            @Override
            public SynthCircuit makeVoice() throws SynthException {
                FilteredSawtoothBL fsbl = new FilteredSawtoothBL();
                fsbl.resonance.set(0.5);
                return this.addVoiceToMix(fsbl);
            }
        };
    }

    public void setMelody(Melody melody) {
        this.melody = melody;
    }

    public void setLoop(boolean looped) {
        this.loop = looped;
    }

    public SynthOutput getOutput() {
        return this.allocator.getOutput();
    }

    void start() {
        this.stop();
        this.thread = new Thread(this);
        this.thread.start();
    }

    void stop() {
        this.die = true;
        try {
            if (this.thread != null) {
                this.thread.join(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    void pause() {
        this.play = false;
    }

    void resume() {
        this.play = true;
        this.notify();
    }

    @Override
    public void run() {
        this.die = false;
        try {
            do {
                this.playMelody();
            } while (!this.die && this.loop);
        }
        catch (SynthException synthException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    void playMelody() {
        idx = 0;
        tempo = (int)(Synth.getTickRate() * this.secondsPerUnitDuration);
        advanceTime = (int)(Synth.getTickRate() * 0.4);
        nextTime = Synth.getTickCount() + advanceTime;
        ** GOTO lbl21
        {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return;
            }
            nextTime = Synth.getTickCount() + advanceTime;
            do {
                if (!this.play && !this.die) continue block2;
                if (!this.play) continue;
                pitch = this.melody.getPitch(idx);
                duration = this.melody.getDuration(idx) * tempo;
                freq = this.pitchToFreq(pitch);
                this.playNote(nextTime, freq, duration / 2);
                Synth.sleepUntilTick((nextTime += duration) - advanceTime);
                ++idx;
lbl21:
                // 3 sources

            } while (!this.die && idx < this.melody.size());
        }
    }

    double pitchToFreq(int pitch) {
        return this.tuning.getFrequency(pitch);
    }

    void playNote(int time, double freq, int duration) {
        SynthNote voice = (SynthNote)this.allocator.steal(time);
        if (voice == null) {
            System.err.println("Couldn't allocate voice.");
        } else {
            voice.note(time, duration, freq, 0.4);
        }
    }

    public double getSecondsPerUnitDuration() {
        return this.secondsPerUnitDuration;
    }

    public void setSecondsPerUnitDuration(double d) {
        this.secondsPerUnitDuration = d;
    }
}

