/*
 * Decompiled with CFR 0.152.
 */
package com.unknown;

import com.unknown.BitStream;
import junit.framework.TestCase;

public class TestBitStream
extends TestCase {
    byte[] bar2 = new byte[]{-91, -57};
    byte[] bar8 = new byte[]{1, 35, 69, 103, -119, -85, -51, -17};

    public void testSingle() {
        BitStream bs = new BitStream(this.bar2);
        TestBitStream.assertEquals("first nibble", 10, bs.readBits(4));
        TestBitStream.assertEquals("second nibble", 5, bs.readBits(4));
        TestBitStream.assertEquals("zero bits", 0, bs.readBits(0));
        TestBitStream.assertEquals("left end", 3, bs.readBits(2));
        TestBitStream.assertEquals("from middle", 1, bs.readBits(4));
        TestBitStream.assertEquals("right end", 3, bs.readBits(2));
    }

    public void testMultiple() {
        BitStream bs = new BitStream(this.bar8);
        TestBitStream.assertEquals("first nibble", 0, bs.readBits(4));
        TestBitStream.assertEquals("span bytes", 18, bs.readBits(8));
        TestBitStream.assertEquals("3 nibbles", 837, bs.readBits(12));
        TestBitStream.assertEquals("2 bits", 1, bs.readBits(2));
        TestBitStream.assertEquals("1 bit", 1, bs.readBits(1));
        TestBitStream.assertEquals("another bit", 0, bs.readBits(1));
        TestBitStream.assertEquals("32 bits", 2023406814, bs.readBits(32));
    }
}

