/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.tests;

import com.transjam.client.Client;
import com.transjam.client.TransjamMessageListener;
import com.transjam.util.TransjamMessage;
import java.applet.Applet;
import java.io.IOException;

public class Tester
extends Applet
implements TransjamMessageListener {
    Client client;
    int numErrors = 0;
    int numSuccesses = 0;
    Tester partner;
    int state = 0;
    private int milestone = 0;
    private boolean done = false;

    public void setPartner(Tester partner) {
        this.partner = partner;
    }

    public boolean expectCommand(TransjamMessage message, String expected) {
        boolean result = this.expectString(message.command, expected);
        if (result) {
            ++this.state;
        }
        return result;
    }

    public boolean expectString(String actual, String expected) {
        if (actual.equals(expected)) {
            ++this.numSuccesses;
            return true;
        }
        System.err.println("ERROR: " + this.client.getName() + " expected " + expected + ", got " + actual);
        ++this.numErrors;
        return false;
    }

    public synchronized void waitForDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println(String.valueOf(this.client.getName()) + " #successes = " + this.numSuccesses);
        System.out.print(String.valueOf(this.client.getName()) + " #errors = " + this.numErrors);
        if (this.numErrors > 0) {
            System.out.println(" !!!!!!!!!!!!!!");
        } else {
            System.out.println();
        }
    }

    public synchronized void setDone() {
        this.done = true;
        this.notifyAll();
    }

    public synchronized void waitForMilestone(int pMilestone) {
        try {
            while (this.client == null) {
                System.out.println("waiting for client creation");
                this.wait(1000L);
            }
            while (pMilestone > this.milestone) {
                System.out.println("waiting for " + this.client.getName() + "'s milestone " + pMilestone + ", still = " + this.milestone);
                this.wait(2000L);
            }
            System.out.println("got " + this.client.getName() + "'s milestone " + pMilestone);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void setMilestone(int pMilestone) {
        System.out.println(String.valueOf(this.client.getName()) + " setting milestone " + pMilestone);
        this.milestone = pMilestone;
        this.notifyAll();
    }

    public int getMilestone() {
        return this.milestone;
    }

    @Override
    public boolean handleMessage(Client client, TransjamMessage message) throws IOException {
        return false;
    }

    @Override
    public void serverDown(Client client) {
    }

    public synchronized void startTest(String userName) throws IOException {
        this.client = new Client();
        this.notifyAll();
        this.client.addMessageListener(this);
        this.client.start();
        this.client.requestLogin(userName);
    }

    public void stopTest() throws IOException {
        this.client.requestLogout();
        this.client.stop();
        this.setDone();
    }
}

