/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import java.util.Vector;

public class MessageQueue {
    private Vector queue = new Vector();

    public synchronized void send(Object msg) {
        this.queue.addElement(msg);
        this.notifyAll();
    }

    public synchronized Object waitForMessage() throws InterruptedException {
        while (!this.isMessageAvailable()) {
            this.wait();
        }
        return this.queue.remove(0);
    }

    public synchronized Object waitForMessage(int timeOutMSec) throws InterruptedException {
        if (!this.isMessageAvailable()) {
            this.wait(timeOutMSec);
        }
        if (this.isMessageAvailable()) {
            return this.queue.remove(0);
        }
        return null;
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isMessageAvailable() {
        return this.queue.size() > 0;
    }
}

