/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.examples.misc;

import com.transjam.awt.AppletTester;
import com.transjam.awt.ClientHelper;
import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Date;

public class GetServerTime
extends Applet {
    Client client;
    ClientHelper helper;
    Button timeButton;
    Label timeLabel;

    @Override
    public void start() {
        this.helper = new ClientHelper();
        int maxClientsPerRoom = 20;
        this.client = this.helper.connect(this, "get_server_time", maxClientsPerRoom);
        if (this.client == null) {
            this.add(new Label("Connection to server failed! Please try again later."));
        } else {
            this.setLayout(new GridLayout(0, 1));
            this.timeButton = new Button("Get Time from Server");
            this.add(this.timeButton);
            this.timeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        GetServerTime.this.client.requestTime();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            });
            this.timeLabel = new Label();
            this.add(this.timeLabel);
            this.setupClientListener();
            this.helper.login();
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void updateTimeDisplay(long utcMillis) {
        Date serverDate = new Date(utcMillis);
        this.timeLabel.setText(serverDate.toString());
    }

    void setupClientListener() {
        ClientAdapter clientAdapter = new ClientAdapter(){

            @Override
            public void gotTime(Date when) throws IOException {
                GetServerTime.this.updateTimeDisplay(when.getTime());
            }
        };
        this.client.addMessageListener(clientAdapter, 2);
    }

    @Override
    public void stop() {
        this.helper.logout();
        this.removeAll();
    }

    public static void main(String[] argv) {
        GetServerTime applet = new GetServerTime();
        AppletTester.test(applet, 300, 100);
    }
}

