/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.DrumSynth;
import com.transjam.drumbox.SongModel;
import com.transjam.drumbox.SongPlayer;
import com.transjam.drumbox.TrackModel;
import com.transjam.drumbox.Tuning;
import java.util.Observable;

public class TrackPlayer
extends Observable
implements Runnable {
    private SongPlayer songPlayer;
    private SongModel songModel;
    private TrackModel trackModel;
    private DrumSynth synth;
    private Thread thread;
    private Object doneLock;
    private volatile boolean go;
    private boolean done = true;
    private int beatIndex;
    private double secondsPerMasterBeat;
    private double masterNextTime;
    private boolean gotMasterBeat = false;
    private boolean isMuted = false;

    public TrackPlayer(SongPlayer songPlayer, TrackModel trackModel, DrumSynth synth) {
        this.songPlayer = songPlayer;
        this.trackModel = trackModel;
        this.songModel = trackModel.getSongModel();
        this.synth = synth;
        this.doneLock = new Object();
    }

    public void start() {
        this.stop();
        this.thread = new Thread((Runnable)this, "Track-" + this.trackModel.getTrackIndex());
        this.go = true;
        this.done = false;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.go = false;
        Object object = this;
        synchronized (object) {
            this.gotMasterBeat = true;
            this.notifyAll();
        }
        if (this.thread != null) {
            try {
                object = this.doneLock;
                synchronized (object) {
                    while (!this.done) {
                        this.doneLock.wait(5000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    synchronized double waitForMaster() {
        try {
            while (!this.gotMasterBeat && this.go) {
                this.wait(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.gotMasterBeat = false;
        return this.masterNextTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            double nextTime = this.synth.getTime();
            this.beatIndex = 0;
            while (this.go) {
                double volume;
                double secondsPerHit = this.secondsPerMasterBeat * ((double)this.trackModel.getInTimeOf() / (double)this.trackModel.getNumBeats());
                if (secondsPerHit > 10.0) {
                    System.err.println("TrackPlayer: secondsPerHit = " + secondsPerHit);
                    secondsPerHit = 10.0;
                }
                if ((volume = (double)this.trackModel.getBeatVolume(this.getBeat()) * 0.333 * this.trackModel.getVolume()) > 0.0 && !this.isMuted && Math.random() < this.trackModel.getProbability()) {
                    Tuning tun = this.songModel.getTuning();
                    int pitch = this.trackModel.getBeatPitch(this.getBeat()) + this.trackModel.getPitchOffset();
                    double frequency = tun.pitchToFrequency(pitch);
                    this.synth.hit(nextTime, secondsPerHit, this.trackModel.getInstrumentIndex(), frequency, volume);
                }
                this.sully();
                boolean waitMaster = false;
                if (this.trackModel.getReversed()) {
                    --this.beatIndex;
                    if (this.beatIndex < 0) {
                        this.beatIndex = this.trackModel.getNumBeats() - 1;
                        waitMaster = true;
                    }
                } else {
                    ++this.beatIndex;
                    if (this.beatIndex >= this.trackModel.getNumBeats()) {
                        this.beatIndex = 0;
                        waitMaster = true;
                    }
                }
                if (waitMaster) {
                    nextTime = this.waitForMaster();
                    continue;
                }
                nextTime += secondsPerHit;
                try {
                    this.synth.sleepUntilTime(nextTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            Object object = this.doneLock;
            synchronized (object) {
                this.done = true;
                this.doneLock.notifyAll();
            }
            throw throwable;
        }
        Object object = this.doneLock;
        synchronized (object) {
            this.done = true;
            this.doneLock.notifyAll();
        }
    }

    public synchronized void masterBeat(int masterBeatIndex, double nextTime, double secondsPerMasterBeat) {
        this.secondsPerMasterBeat = secondsPerMasterBeat;
        if (masterBeatIndex % this.trackModel.getInTimeOf() == 0) {
            this.masterNextTime = nextTime;
            this.gotMasterBeat = true;
            this.notifyAll();
        }
    }

    public int getBeat() {
        return this.beatIndex;
    }

    void setMute(boolean isMuted) {
        this.isMuted = isMuted;
    }

    boolean getMute() {
        return this.isMuted;
    }

    void sully() {
        this.setChanged();
        this.notifyObservers();
    }
}

