/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.client;

import com.transjam.client.TransjamMessageListener;
import com.transjam.util.ClientBase;
import com.transjam.util.DebugLog;
import com.transjam.util.TransjamMessage;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Client
extends ClientBase {
    private Hashtable userNames;
    private String syncContent = null;
    private int nextSync = 0;
    private Vector[] levelListeners;
    private int level;

    public Client() throws UnknownHostException, IOException {
        this(null, 17952, 15000);
    }

    public Client(String serverName, int portnum) throws UnknownHostException, IOException {
        this(serverName, portnum, 15000);
    }

    public Client(String serverName, int portnum, int timeoutMSec) throws UnknownHostException, IOException {
        InetAddress dst = null;
        DebugLog.debugln("Client: portnum = " + portnum);
        if (serverName == null) {
            DebugLog.debugln("Client: Use getLocalHost()");
            dst = InetAddress.getLocalHost();
        } else {
            DebugLog.debugln("Client: Use getByName(" + serverName + ")");
            dst = InetAddress.getByName(serverName);
        }
        DebugLog.debugln("Login to: " + dst);
        Socket socket = new Socket(dst, portnum);
        this.setSocket(socket, timeoutMSec);
        this.userNames = new Hashtable();
        this.levelListeners = new Vector[3];
        int i = 0;
        while (i < this.levelListeners.length) {
            this.levelListeners[i] = new Vector();
            ++i;
        }
    }

    void addUser(int userID, String userName) {
        this.userNames.put(new Integer(userID), userName);
    }

    void deleteUser(int userID) {
        this.userNames.remove(new Integer(userID));
    }

    void removeAllUsers() {
        this.userNames.clear();
    }

    public String getUserName(int userID) {
        return (String)this.userNames.get(new Integer(userID));
    }

    synchronized void gotSync(String content) {
        this.syncContent = content;
        this.notifyAll();
    }

    @Override
    public void gotTimeout(int numTimeouts) throws IOException {
        if (numTimeouts != 1) {
            throw new IOException("Server not responding.");
        }
        this.requestEcho("serverCheck");
    }

    @Override
    public void gotThrowable(Throwable exc) {
        this.hadError = true;
        DebugLog.debugln("Client.gotThrowable() called. Got " + exc);
        exc.printStackTrace();
        try {
            String msg = this.writer.sendChat(this.getUserID(), 1, "Logging out " + this.getName() + " because of exception!!!\n" + exc);
            this.write(msg);
            msg = this.writer.requestLogout();
            this.write(msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void gotStart() {
    }

    @Override
    public void gotStop() {
        this.serverDown();
    }

    public synchronized void sync() throws InterruptedException, IOException {
        String syncMsg = "" + this.nextSync++;
        this.sendSync(syncMsg);
        while (!syncMsg.equals(this.syncContent)) {
            this.wait();
        }
    }

    public void addMessageListener(TransjamMessageListener listener, int level) {
        this.levelListeners[level].addElement(listener);
    }

    public void removeMessageListener(TransjamMessageListener listener, int level) {
        this.levelListeners[level].removeElement(listener);
    }

    public void addMessageListener(TransjamMessageListener listener) {
        int i = 0;
        while (i < this.levelListeners.length) {
            this.addMessageListener(listener, i);
            ++i;
        }
    }

    public void removeMessageListener(TransjamMessageListener listener) {
        int i = 0;
        while (i < this.levelListeners.length) {
            this.removeMessageListener(listener, i);
            ++i;
        }
    }

    @Override
    public void gotMessage(TransjamMessage message) {
        try {
            this.processMessage(message);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void write(String msg) throws IOException {
        this.writeSocket(msg);
    }

    public void processMessage(TransjamMessage message) throws IOException {
        int uid;
        if (message.command.equals("reqecho")) {
            this.replyEcho(message.content);
            DebugLog.debugln(104, "got: " + message);
            return;
        }
        if (message.command.equals("echo")) {
            DebugLog.debugln(104, "got: " + message);
            return;
        }
        DebugLog.debugln(114, "got: " + message);
        if (message.command.equals("sync")) {
            this.gotSync(message.content);
        } else if (message.command.equals("validate")) {
            if (!this.checkValidationMessage(message.content)) {
                throw new IOException("Server validation failed!");
            }
        } else if (message.command.equals("grantlogin")) {
            this.setUserID(message.get("uid", -1));
        } else if (message.command.equals("adduser")) {
            uid = message.get("uid", 0);
            this.addUser(uid, message.content);
        } else if (message.command.equals("deleteuser")) {
            uid = message.get("uid", 0);
            this.deleteUser(uid);
        } else if (message.command.equals("exitroom")) {
            this.removeAllUsers();
        } else if (message.command.equals("enterroom")) {
            this.level = message.get("level", this.level);
        }
        Enumeration e = this.levelListeners[this.level > 2 ? 2 : this.level].elements();
        while (e.hasMoreElements()) {
            ((TransjamMessageListener)e.nextElement()).handleMessage(this, message);
        }
    }

    public void serverDown() {
        Enumeration e = this.levelListeners[this.level > 2 ? 2 : this.level].elements();
        while (e.hasMoreElements()) {
            ((TransjamMessageListener)e.nextElement()).serverDown(this);
        }
    }

    public void requestLogin(String userName) throws IOException {
        this.requestValidation();
        this.setName(userName);
        this.write(this.writer.requestLogin(userName));
    }

    public void requestLogout() throws IOException {
        this.write(this.writer.requestLogout());
    }

    public void requestTime() throws IOException {
        this.write(this.writer.requestTime());
    }

    public void joinRoom(String name) throws IOException {
        this.checkValidity();
        this.write(this.writer.joinRoom(name));
    }

    public void joinRoom(String name, int maxClients, int flags) throws IOException {
        this.checkValidity();
        this.write(this.writer.joinRoom(name, this.level, maxClients, flags));
    }

    public void joinNewRoom(String name, int maxClients, int flags) throws IOException {
        this.checkValidity();
        this.write(this.writer.joinNewRoom(name, this.level, maxClients, flags));
    }

    public void joinNewRoom(String name) throws IOException {
        this.checkValidity();
        this.write(this.writer.joinNewRoom(name));
    }

    public void joinOldRoom(String name) throws IOException {
        this.checkValidity();
        this.write(this.writer.joinOldRoom(name, this.level));
    }

    public void leaveRoom() throws IOException {
        this.write(this.writer.leaveRoom(this.level));
    }

    public void lockNewThing(String name, String contents) throws IOException {
        this.write(this.writer.lockNewThing(name, contents));
    }

    public void lockOldThing(String name) throws IOException {
        this.write(this.writer.lockOldThing(name));
    }

    public void unlockThing(String name) throws IOException {
        this.write(this.writer.unlockThing(name));
    }

    public void grantLock(String name) throws IOException {
        this.write(this.writer.grantLock(name));
    }

    public void requestUserList() throws IOException {
        this.write(this.writer.requestUserList());
    }

    public void requestUserLocations() throws IOException {
        this.write(this.writer.requestUserLocations());
    }

    public void requestThingList() throws IOException {
        this.write(this.writer.requestThingList());
    }

    public void requestRoomList() throws IOException {
        this.write(this.writer.requestRoomList());
    }

    public void sendChat(String msg, int flags) throws IOException {
        String txt = this.writer.sendChat(msg, flags);
        this.write(txt);
    }
}

