/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.chatter;

import com.transjam.awt.AppletTester;
import com.transjam.awt.ChatPanel;
import com.transjam.awt.ClientHelper;
import com.transjam.client.Client;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ChatInFrame
extends Applet {
    private ClientHelper helper;
    private ChatPanel chatPanel;
    private Client client;
    private Frame chatFrame;
    private Button showChatButton;

    public static void main(String[] argv) {
        ChatInFrame applet = new ChatInFrame();
        AppletTester.test(applet, 200, 80);
    }

    @Override
    public void start() {
        this.helper = new ClientHelper();
        int maxClientsPerRoom = 10;
        this.chatFrame = new Frame("TransJam Chat by SoftSynth.com"){

            @Override
            public boolean handleEvent(Event evt) {
                switch (evt.id) {
                    case 201: {
                        ChatInFrame.this.chatFrame.hide();
                        return true;
                    }
                }
                return super.handleEvent(evt);
            }
        };
        this.client = this.helper.connect(this, this.chatFrame, "chatter", maxClientsPerRoom);
        if (this.client == null) {
            this.add(new Label("Connection to server failed! Please try again later."));
        } else {
            this.setLayout(new BorderLayout());
            this.setupChat();
            this.add("Center", this.showChatButton);
            this.chatPanel.start();
            this.helper.login();
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void setupChat() {
        this.chatFrame.setSize(600, 400);
        this.chatPanel = new ChatPanel(this.client);
        this.chatFrame.add(this.chatPanel);
        this.showChatButton = new Button("Show Chat Window");
        this.showChatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatInFrame.this.chatFrame.show();
            }
        });
    }

    @Override
    public void stop() {
        this.helper.logout();
        this.removeAll();
    }
}

