/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import com.transjam.awt.CheckCountGrid;
import com.transjam.awt.StringResources;
import com.transjam.client.MeetingSchedule;
import com.transjam.util.Meeting;
import com.transjam.util.Schedule;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;

public class ScheduleDialog
extends Dialog
implements Observer {
    private Button updateButton;
    private Button joinButton;
    private Button cancelButton;
    private Label[] dayLabels;
    private CheckCountGrid checkGrid;
    private Date previousMidnight;
    private int numDays = 7;
    private MeetingSchedule meetingSchedule;
    private static final int HOURS_PER_DAY = 24;
    private static final int MILLIS_PER_HOUR = 3600000;
    private int currentHour = 0;

    public ScheduleDialog(Frame frame, MeetingSchedule meetingSchedule) {
        super(frame, "Meeting Schedule", false);
        this.meetingSchedule = meetingSchedule;
        meetingSchedule.addObserver(this);
        meetingSchedule.start();
        this.setSize(800, 400);
        this.setLayout(new BorderLayout());
        Panel infoPanel = new Panel();
        infoPanel.setLayout(new GridLayout(0, 1));
        this.add("North", infoPanel);
        infoPanel.add(new Label("Numbers in grid show how many people plan to come back at that time."));
        infoPanel.add(new Label("Check the white box(es) of the time(s) when you plan to come back. Then hit OK"));
        this.add("Center", this.buildGrid(24, this.numDays));
        Panel buttonPanel = new Panel();
        this.add("South", buttonPanel);
        this.joinButton = new Button("OK");
        buttonPanel.add(this.joinButton);
        this.joinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScheduleDialog.this.joinMeetings();
                    ScheduleDialog.this.hide();
                }
                catch (IOException exc) {
                    System.err.println("Caught exc" + exc);
                }
            }
        });
        this.cancelButton = new Button("Cancel");
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScheduleDialog.this.hide();
            }
        });
        this.updateButton = new Button("Update");
        buttonPanel.add(this.updateButton);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScheduleDialog.this.requestMeetingList();
                }
                catch (IOException exc) {
                    System.err.println("Caught exc" + exc);
                }
            }
        });
        this.validate();
    }

    Panel buildGrid(int numPerDay, int numDays) {
        int numRows = numDays + 1;
        int numColumns = numPerDay + 1;
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel topPanel = new Panel();
        topPanel.setLayout(new GridLayout(1, 0));
        panel.add("North", topPanel);
        topPanel.add(new Label("Time"));
        int icol = 0;
        while (icol < numPerDay) {
            int hour = (icol + 11) % 12 + 1;
            String ampm = hour < 10 ? (icol < 12 ? "AM" : "PM") : (icol < 12 ? "A" : "P");
            String hourText = String.valueOf(hour) + ampm;
            Label lbl = new Label(hourText, 2);
            topPanel.add(lbl);
            ++icol;
        }
        Panel sidePanel = new Panel();
        sidePanel.setLayout(new GridLayout(0, 1));
        panel.add("West", sidePanel);
        this.dayLabels = new Label[numDays];
        int i = 0;
        while (i < numDays) {
            this.dayLabels[i] = new Label("Mon", 2);
            sidePanel.add(this.dayLabels[i]);
            ++i;
        }
        this.checkGrid = new CheckCountGrid(numDays, numPerDay){

            public int getValue(int row, int column) {
                return 0;
            }
        };
        this.checkGrid.setBackground(Color.lightGray);
        panel.add("Center", this.checkGrid);
        return panel;
    }

    Date slotToDate(int slotIndex) {
        long utc = this.previousMidnight.getTime();
        return new Date(utc += (long)((slotIndex - this.currentHour) * 3600000));
    }

    int dateToSlot(Date when) {
        long deltaMillis = when.getTime() - this.previousMidnight.getTime();
        int slot = (int)(deltaMillis / 3600000L);
        return slot + this.currentHour;
    }

    void joinMeetings() throws IOException {
        int i = 0;
        while (i < this.checkGrid.getNumElements()) {
            if (this.checkGrid.getState(i)) {
                Date when = this.slotToDate(i);
                this.meetingSchedule.joinMeeting(when);
                this.checkGrid.setState(i, false);
            }
            ++i;
        }
    }

    public void requestMeetingList() throws IOException {
        this.meetingSchedule.requestMeetingList();
    }

    @Override
    public void update(Observable o, Object arg) {
        Date serverDate = this.meetingSchedule.getServerDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(serverDate);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(10, 1);
        this.currentHour = calendar.get(11);
        this.previousMidnight = calendar.getTime();
        int i = this.currentHour;
        while (i < this.checkGrid.getNumElements()) {
            this.checkGrid.setEnabled(i, true);
            ++i;
        }
        int startDay = calendar.get(7) - 1;
        int i2 = 0;
        while (i2 < this.numDays) {
            String dayName = StringResources.DAY_NAMES[startDay % 7];
            this.dayLabels[i2].setText(dayName);
            ++startDay;
            ++i2;
        }
        Schedule schedule = this.meetingSchedule.getSchedule();
        Enumeration enumer = schedule.getMeetings();
        while (enumer.hasMoreElements()) {
            Meeting meeting = (Meeting)enumer.nextElement();
            Date when = meeting.getDate();
            int slotIndex = this.dateToSlot(when);
            this.checkGrid.setCount(slotIndex, meeting.getCount());
        }
        this.repaint();
    }

    @Override
    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 201: {
                this.hide();
            }
        }
        return super.handleEvent(evt);
    }
}

