/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ImageCanvas
extends Canvas {
    Image image;

    public ImageCanvas() {
    }

    public ImageCanvas(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.image = image;
        this.setSize(image.getWidth(this), image.getHeight(this));
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    @Override
    public void paint(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, this);
        }
    }

    public void load(URL imageURL) throws IOException {
        InputStream stream = imageURL.openConnection().getInputStream();
        Image img = ImageCanvas.loadImage(this, stream);
        this.setImage(img);
    }

    protected static byte[] loadEntireStream(InputStream inStream) throws IOException {
        int numRead;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((numRead = inStream.read(buffer)) >= 0) {
            outStream.write(buffer, 0, numRead);
        }
        return outStream.toByteArray();
    }

    protected static Image loadImage(Component comp, InputStream inStream) throws IOException {
        byte[] bytes = ImageCanvas.loadEntireStream(inStream);
        Image img = null;
        try {
            MediaTracker m = new MediaTracker(comp);
            img = Toolkit.getDefaultToolkit().createImage(bytes);
            m.addImage(img, 0);
            m.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }
}

