/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import com.transjam.awt.ContainerHack;
import com.transjam.awt.LoginLobbyPanel;
import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import com.transjam.util.DebugLog;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;

public class ClientLoginManager {
    protected Client client;
    protected LoginLobbyPanel loginLobbyPanel;
    protected ClientAdapter clientAdapter;
    protected Applet applet;
    protected Frame frame;

    public Client connect(Applet applet, String lobbyName, int maxClientsPerRoom) {
        this.applet = applet;
        Frame parentFrame = this.getParentFrame(applet);
        return this.connect(applet, parentFrame, lobbyName, maxClientsPerRoom);
    }

    public Client connect(Applet applet, Frame frame, String lobbyName, int maxClientsPerRoom) {
        this.frame = frame;
        String hostName = "www.transjam.com";
        try {
            URL codeBase = applet.getCodeBase();
            DebugLog.debugln("CodeBase = " + codeBase);
            String temp = codeBase.getHost();
            if (temp != null) {
                hostName = temp;
            }
        }
        catch (NullPointerException codeBase) {
            // empty catch block
        }
        int portNum = 17952;
        try {
            String portString = applet.getParameter("transjamPort");
            if (portString != null) {
                try {
                    portNum = Integer.parseInt(portString);
                    System.out.println("Use transjamPort parameter = " + portNum);
                }
                catch (NumberFormatException e) {
                    System.err.println("Error in transjamPort parameter. Caught " + e);
                }
            }
        }
        catch (NullPointerException portString) {
            // empty catch block
        }
        this.client = null;
        try {
            this.client = new Client(hostName, portNum);
            this.loginLobbyPanel = new LoginLobbyPanel(frame, this.client, lobbyName, maxClientsPerRoom);
            this.clientAdapter = new ClientAdapter(){

                @Override
                public void enteredRoom(String name, int level) throws IOException {
                    ClientLoginManager.this.showLogin();
                }

                @Override
                public void exitedRoom(String name, int level) throws IOException {
                    ClientLoginManager.this.hideLogin();
                }
            };
            this.client.addMessageListener(this.clientAdapter, 1);
            this.loginLobbyPanel.start();
            this.client.start();
        }
        catch (ConnectException ioe) {
            if (this.client != null) {
                this.client.stop();
            }
            this.client = null;
        }
        catch (IOException ioe) {
            System.err.println("Caught " + ioe);
            ioe.printStackTrace();
        }
        return this.client;
    }

    public Frame getParentFrame(Component comp) {
        while ((comp = comp.getParent()) != null) {
            if (!(comp instanceof Frame)) continue;
            return (Frame)comp;
        }
        return null;
    }

    public void login() {
        this.showLogin();
    }

    public void hideLogin() {
        this.applet.remove(this.loginLobbyPanel);
    }

    public void showLogin() {
        if (!this.applet.isAncestorOf(this.loginLobbyPanel)) {
            this.applet.add(this.loginLobbyPanel);
            this.syncContainer();
        }
    }

    private void syncContainer() {
        ContainerHack.syncContainer(this.applet);
    }

    public void logout() {
        try {
            if (this.client != null) {
                this.client.requestLogout();
                this.client.stop();
                if (this.clientAdapter != null) {
                    this.client.removeMessageListener(this.clientAdapter, 1);
                }
                this.client = null;
            }
        }
        catch (IOException ioe) {
            System.err.println("Caught " + ioe);
            ioe.printStackTrace();
        }
    }
}

