/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.admin;

import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Date;

public class CheckServer {
    private Client client;
    private int numErrors = 0;
    private boolean grantedLogin = false;
    private Object semaphore = new Object();

    public static void main(String[] args) {
        CheckServer checker = new CheckServer();
        int result = checker.test();
        System.exit(result);
    }

    private void sleepSeconds(int seconds) {
        System.out.println("Sleep for " + seconds + " seconds.");
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Woke up.");
    }

    private int test() {
        System.out.println("TransJam report by CheckServer on " + new Date());
        try {
            this.startTest("transjam_checker");
            if (!this.waitForGrant()) {
                this.logError("Server did not grant login!");
            }
            this.stopTest();
        }
        catch (ConnectException exc) {
            this.logError("Could not connect to server!");
        }
        catch (IOException exc) {
            System.err.println(exc);
            exc.printStackTrace(System.err);
        }
        System.out.println("#errors = " + this.numErrors);
        return this.numErrors;
    }

    void logError(String msg) {
        ++this.numErrors;
        System.out.println("ERROR: " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForGrant() {
        Object object = this.semaphore;
        synchronized (object) {
            int countDown = 5;
            try {
                while (!this.grantedLogin && countDown-- > 0) {
                    this.semaphore.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.grantedLogin;
    }

    public void serverDown(Client client) {
    }

    private void startTest(String userName) throws IOException {
        this.client = new Client();
        this.client.addMessageListener(new ClientAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantedLogin(int uid) throws IOException {
                System.out.println("SUCCESS: Got login.");
                Object object = CheckServer.this.semaphore;
                synchronized (object) {
                    CheckServer.this.grantedLogin = true;
                    CheckServer.this.semaphore.notifyAll();
                }
            }
        });
        this.client.start();
        this.client.requestLogin(userName);
    }

    private void stopTest() throws IOException {
        this.client.requestLogout();
        this.client.stop();
    }
}

