/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.admin;

import com.transjam.admin.AdminAdapter;
import com.transjam.admin.AdminControlPanel;
import com.transjam.admin.AdminLoginPanel;
import com.transjam.admin.Administrator;
import com.transjam.awt.AppletTester;
import com.transjam.util.DebugLog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Label;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;

public class AdminApplet
extends Applet {
    Administrator admin;
    AdminAdapter adminAdapter;
    AdminLoginPanel adminLoginPanel;
    AdminControlPanel controlPanel;
    String hostName = null;
    int portIndex = 17953;

    protected int getIntegerParameter(String paramName, int defaultValue) {
        int value = defaultValue;
        String temp = this.getParameter(paramName);
        if (temp != null) {
            try {
                value = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                System.err.println("Error in " + paramName + " parameter. Caught " + e);
            }
        }
        return value;
    }

    @Override
    public void start() {
        try {
            this.portIndex = this.getIntegerParameter("portnum", this.portIndex);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.hostName == null) {
            try {
                URL codeBase = this.getCodeBase();
                DebugLog.debugln("CodeBase = " + codeBase);
                String temp = codeBase.getHost();
                if (temp != null) {
                    this.hostName = temp;
                }
            }
            catch (NullPointerException codeBase) {
                // empty catch block
            }
        }
        try {
            this.admin = new Administrator(this.hostName, this.portIndex);
            this.adminAdapter = new AdminAdapter(){

                @Override
                public void enteredRoom(String name, int level) throws IOException {
                    if (level == 1) {
                        AdminApplet.this.setLayout(new FlowLayout());
                        AdminApplet.this.add(AdminApplet.this.adminLoginPanel);
                        AdminApplet.this.getParent().validate();
                        AdminApplet.this.getToolkit().sync();
                    }
                }

                @Override
                public void grantedAdmin(int uid) {
                    AdminApplet.this.removeAll();
                    AdminApplet.this.setLayout(new BorderLayout());
                    AdminApplet.this.add("Center", AdminApplet.this.controlPanel);
                    AdminApplet.this.controlPanel.start();
                    AdminApplet.this.getParent().validate();
                    AdminApplet.this.getToolkit().sync();
                }

                @Override
                public void deniedAdmin(String reason) {
                    AdminApplet.this.adminLoginPanel.setMessage("Admin Login denied: " + reason);
                }
            };
            this.admin.addMessageListener(this.adminAdapter);
            this.admin.start();
            this.controlPanel = new AdminControlPanel(this.admin);
            this.adminLoginPanel = new AdminLoginPanel(this.admin);
            this.add(this.adminLoginPanel);
        }
        catch (ConnectException ioe) {
            this.add(new Label("ERROR: Could not connect to Server! Please try again later."));
        }
        catch (IOException ioe) {
            System.err.println("Caught " + ioe);
            ioe.printStackTrace();
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            if (this.admin != null) {
                this.admin.requestLogout();
                this.admin.removeMessageListener(this.adminAdapter);
            }
            this.removeAll();
            this.admin = null;
        }
        catch (IOException ioe) {
            System.err.println("Caught " + ioe);
            ioe.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        AdminApplet applet = new AdminApplet();
        AppletTester.test(applet, 700, 600);
    }
}

