/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.model.music.TimeSelectable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class TimeSelectionBar
extends JComponent
implements MouseListener,
MouseMotionListener {
    private TimeSelectable timeSelectable;
    private double leftTime;
    private double timeWidth;
    private int leftSelected;
    private int rightSelected;
    private int downX;

    public TimeSelectionBar(TimeSelectable timeSelectable) {
        this.timeSelectable = timeSelectable;
        this.setBackground(new Color(220, 255, 255));
        this.setPreferredSize(new Dimension(20, 20));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.leftTime = this.timeSelectable.getLeftTime();
        this.timeWidth = this.timeSelectable.getTimeWidth();
        g.setColor(Color.ORANGE);
        g.fillRect(this.leftSelected, 0, 1 + this.rightSelected - this.leftSelected, this.getHeight());
        g.setColor(Color.BLACK);
        double time = this.leftTime;
        double rightTime = this.leftTime + this.timeWidth;
        while (time < rightTime) {
            int x = this.convertTimeToX(time);
            g.drawLine(x, 0, x, this.getHeight());
            g.drawString("" + (int)time, x + 2, 12);
            time += 1.0;
        }
    }

    private int convertTimeToX(double time) {
        return (int)((double)this.getWidth() * (time - this.leftTime) / this.timeWidth);
    }

    private double convertXToTime(int x) {
        return this.leftTime + this.timeWidth * (double)x / (double)this.getWidth();
    }

    private void setMovingSelection(int x) {
        if (x > this.downX) {
            this.leftSelected = this.downX;
            this.rightSelected = x;
        } else {
            this.leftSelected = x;
            this.rightSelected = this.downX;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setMovingSelection(e.getX());
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.leftSelected = this.downX = e.getX();
        this.rightSelected = this.downX;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setMovingSelection(e.getX());
        this.repaint();
    }

    public double getStartOffset() {
        return this.convertXToTime(this.leftSelected);
    }

    public double getStopOffset() {
        return this.convertXToTime(this.rightSelected);
    }
}

