/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.math.PrimeFactors;
import com.softsynth.score.ScoreElement;
import com.softsynth.util.NumericOutput;
import com.syntona.model.music.DynamicNote;
import com.syntona.model.music.DynamicTrack;
import com.syntona.model.music.TimeSelectable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;

public class DynamicIntonationTrackView
extends JComponent
implements MouseListener,
MouseMotionListener,
TimeSelectable {
    private static final Color COLOR_NOTE_HEAD = Color.BLACK;
    private static final Color COLOR_NOTE_HEAD_HIGH = new Color(200, 100, 100);
    private static final Color COLOR_NOTE_STEM = Color.BLUE;
    private static final Color COLOR_NOTE_STEM_HIGH = Color.CYAN;
    private static final Color COLOR_NOTE_RATIO = Color.RED;
    private static final Color COLOR_NOTE_RATIO_HIGH = Color.BLUE;
    private static final Color COLOR_SCALES = Color.GRAY;
    private static final Color COLOR_SELECTION_RECTANGLE = new Color(200, 200, 100, 100);
    private static final Color COLOR_PASTED_GHOST = new Color(50, 200, 50, 180);
    private static final Color COLOR_RELINK_RUBBER_BAND = Color.ORANGE;
    public static final double MIN_ONTIME = 0.125;
    private Mode mode = Mode.ADD;
    private Dragger dragger;
    private DynamicTrack dynamicTrack;
    private double leftTime = -1.0;
    private double timeWidth = 200.0;
    private double pitchHeight = 54.0;
    private double centerPitch = 60.0;
    private double headHeight = 1.0;
    private BasicStroke horizontalStroke;
    private BasicStroke verticalStroke;
    private BasicStroke timeScaleStroke;
    private AffineTransform transformDtoU;
    private HashMap<DynamicNote, Point2D.Double> selectedNoteMap = new HashMap();
    private Image bufferedImage;
    private Image cachedImage;
    private Rectangle selectRectangle;
    private float verticalStrokeWidth = 0.1f;
    private DynamicNote[] pastedNoteArray;
    private boolean showPastedNotes;
    private Point2D pastedNoteTimePitch;
    private double pastedPitchMaximum;
    private double pastedTimeMinimum;
    private int savedWidth;
    private int savedHeight;
    private int cachedImageHeight;
    private int cachedImageWidth;
    private DynamicNote popupNote;
    private DynamicNote playingNote;

    public DynamicIntonationTrackView(DynamicTrack dynamicTrack) {
        this.dynamicTrack = dynamicTrack;
        this.horizontalStroke = new BasicStroke(0.2f);
        this.verticalStroke = new BasicStroke(this.verticalStrokeWidth);
        this.timeScaleStroke = new BasicStroke(this.verticalStrokeWidth * 0.25f);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void reset() {
        this.dragger = null;
        this.playingNote = null;
        this.pastedNoteArray = null;
        this.popupNote = null;
        this.selectedNoteMap.clear();
        this.updateCursor(this.getMode());
        this.requestFullRepaint();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.updateCursor(mode);
    }

    private void updateCursor(Mode mode) {
        Cursor cursor = null;
        if (this.dragger != null) {
            cursor = this.dragger.getCursor();
        }
        if (cursor == null) {
            switch (mode) {
                case SELECT: 
                case RELINK: {
                    cursor = Cursor.getPredefinedCursor(0);
                    break;
                }
                case ADD: {
                    cursor = Cursor.getPredefinedCursor(1);
                }
            }
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
    }

    private Point2D.Double createTimePitch(DynamicNote note) {
        return new Point2D.Double(note.getTime(), note.getPitch());
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        boolean highlight = false;
        if (this.bufferedImage == null || this.savedWidth != w || this.savedHeight != h || this.dragger != null && this.dragger.doFullPaint()) {
            this.bufferedImage = this.getCachedImage(w, h);
            this.fullPaint(this.bufferedImage.getGraphics(), highlight);
            this.savedWidth = w;
            this.savedHeight = h;
        }
        g.drawImage(this.bufferedImage, 0, 0, this);
        Graphics2D g2 = this.pickInPaint(g);
        if (g2 == null) {
            g2 = this.setupGraphics2D(g);
        }
        if (this.dragger != null) {
            this.dragger.paint2D(g2);
        }
        highlight = true;
        this.drawDynamicNotes(g2, this.selectedNoteMap.keySet(), highlight);
        this.drawPastedNotes(g2);
        if (this.popupNote != null) {
            this.drawNotePopup(g2, this.popupNote);
        }
        if (this.playingNote != null) {
            g2.setColor(Color.GREEN);
            g2.fill(this.createNoteShape(this.playingNote));
        }
    }

    private Image getCachedImage(int w, int h) {
        if (this.cachedImage == null || this.cachedImageWidth != w || this.cachedImageHeight != h) {
            this.cachedImage = this.createImage(w, h);
            this.cachedImageWidth = w;
            this.cachedImageHeight = h;
        }
        return this.cachedImage;
    }

    private void drawPastedNotes(Graphics2D g2) {
        if (this.showPastedNotes && this.pastedNoteArray != null && this.pastedNoteTimePitch != null) {
            g2.setColor(COLOR_PASTED_GHOST);
            double pitchOffset = this.pastedNoteTimePitch.getY() - this.pastedPitchMaximum;
            double timeOffset = this.pastedNoteTimePitch.getX() - this.pastedTimeMinimum;
            DynamicNote[] dynamicNoteArray = this.pastedNoteArray;
            int n = this.pastedNoteArray.length;
            int n2 = 0;
            while (n2 < n) {
                DynamicNote note = dynamicNoteArray[n2];
                g2.fill(this.createNoteShape(note, timeOffset, pitchOffset));
                ++n2;
            }
        }
    }

    private Graphics2D pickInPaint(Graphics g) {
        Graphics2D g2 = null;
        if (this.selectRectangle != null) {
            g.setColor(COLOR_SELECTION_RECTANGLE);
            g.fillRect(this.selectRectangle.x, this.selectRectangle.y, this.selectRectangle.width, this.selectRectangle.height);
            g2 = this.setupGraphics2D(g);
            Shape shapeHit = this.transformDtoU.createTransformedShape(this.selectRectangle);
            this.selectedNoteMap.clear();
            this.pickNotes(shapeHit);
        }
        return g2;
    }

    private void pickNotes(Shape shapeHit) {
        List<ScoreElement> notes = this.dynamicTrack.getElements();
        for (ScoreElement scoreElement : notes) {
            DynamicNote note = (DynamicNote)scoreElement;
            RectangularShape shape = this.createNoteShape(note);
            if (!shapeHit.intersects(shape.getBounds2D())) continue;
            this.selectNote(note);
        }
    }

    void fullPaint(Graphics g, boolean highlight) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D g2 = this.setupGraphics2D(g);
        g2.setColor(COLOR_SCALES);
        this.drawScales(g2);
        this.drawNoteList(g2, this.dynamicTrack.getElements(), highlight);
    }

    private void drawNoteList(Graphics2D g2, List<ScoreElement> notes, boolean highlight) {
        DynamicNote note;
        for (ScoreElement scoreElement : notes) {
            note = (DynamicNote)scoreElement;
            this.drawNoteStem(g2, note, highlight);
        }
        for (ScoreElement scoreElement : notes) {
            note = (DynamicNote)scoreElement;
            this.drawNoteHead(g2, note, highlight);
        }
        for (ScoreElement scoreElement : notes) {
            note = (DynamicNote)scoreElement;
            this.drawNoteRatio(g2, note, highlight);
        }
    }

    private void drawDynamicNotes(Graphics2D g2, Collection<DynamicNote> notes, boolean highlight) {
        for (DynamicNote note : notes) {
            this.drawNoteStem(g2, note, highlight);
        }
        for (DynamicNote note : notes) {
            this.drawNoteHead(g2, note, highlight);
        }
        for (DynamicNote note : notes) {
            this.drawNoteRatio(g2, note, highlight);
        }
    }

    private boolean isNoteSelected(DynamicNote note) {
        return this.selectedNoteMap.get(note) != null;
    }

    private Graphics2D setupGraphics2D(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHints(rh);
        this.setupTransform(g2);
        return g2;
    }

    private void setupTransform(Graphics2D g2) {
        int w = this.getWidth();
        int h = this.getHeight();
        double xScale = (double)w / this.timeWidth;
        double yScale = (double)h / this.pitchHeight;
        AffineTransform transformUtoD = new AffineTransform();
        transformUtoD.scale(xScale, 0.0 - yScale);
        transformUtoD.translate(-this.leftTime, -(this.centerPitch + this.pitchHeight / 2.0));
        g2.transform(transformUtoD);
        try {
            this.transformDtoU = transformUtoD.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    private void drawScales(Graphics2D g2) {
        this.drawPitchScales(g2);
        this.drawTimeScales(g2);
    }

    private void drawTimeScales(Graphics2D g2) {
        double bottomPitch = this.centerPitch - this.pitchHeight / 2.0;
        double topPitch = bottomPitch + this.pitchHeight;
        g2.setStroke(this.timeScaleStroke);
        double time = this.leftTime;
        double topTime = time + this.timeWidth;
        g2.setColor(COLOR_SCALES.brighter());
        while (time < topTime) {
            g2.draw(new Line2D.Double(time, bottomPitch, time, topPitch));
            time += 0.25;
        }
        g2.setColor(COLOR_SCALES);
        time = this.leftTime;
        while (time < topTime) {
            g2.draw(new Line2D.Double(time, bottomPitch, time, topPitch));
            time += 1.0;
        }
    }

    private void drawPitchScales(Graphics2D g2) {
        g2.setStroke(this.horizontalStroke);
        double pitch = this.centerPitch - this.pitchHeight / 2.0;
        double topPitch = pitch + this.pitchHeight;
        while (pitch < topPitch) {
            g2.setColor(COLOR_SCALES.brighter());
            g2.draw(new Line2D.Double(this.leftTime, pitch, this.leftTime + this.timeWidth, pitch));
            pitch += 1.0;
        }
        g2.setColor(COLOR_SCALES);
        pitch = this.centerPitch - 24.0;
        int i = 0;
        while (i < 5) {
            g2.draw(new Line2D.Double(this.leftTime, pitch, this.leftTime + this.timeWidth, pitch));
            pitch += 12.0;
            ++i;
        }
    }

    private DynamicNote pickNote(Point2D timePitch) {
        List<ScoreElement> notes = this.dynamicTrack.getElements();
        for (ScoreElement scoreElement : notes) {
            DynamicNote note = (DynamicNote)scoreElement;
            RectangularShape shape = this.createNoteShape(note);
            if (!shape.contains(timePitch)) continue;
            return note;
        }
        return null;
    }

    private RectangularShape createNoteShape(DynamicNote note) {
        return this.createNoteShape(note, 0.0, 0.0);
    }

    private RectangularShape createNoteShape(DynamicNote note, double timeOffset, double pitchOffset) {
        double pitch = note.getPitch() + pitchOffset;
        double time = note.getTime() + timeOffset;
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(time, pitch - this.headHeight / 2.0, note.getOnTime(), this.headHeight, 0.2, 0.2);
        return shape;
    }

    private void drawNoteStem(Graphics2D g2, DynamicNote note, boolean highlight) {
        double pitch = note.getPitch();
        double time = note.getTime();
        DynamicNote basis = note.getBasis();
        if (basis != null) {
            g2.setColor(highlight ? COLOR_NOTE_STEM_HIGH : COLOR_NOTE_STEM);
            double pitchBasis = basis.getPitch();
            double timeBasis = basis.getTime();
            double xpos = time + (double)this.verticalStrokeWidth / 2.0;
            double xposBasis = timeBasis + (double)this.verticalStrokeWidth / 2.0;
            double xMiddle = (xposBasis + xpos) / 2.0;
            g2.setStroke(this.horizontalStroke);
            g2.draw(new Line2D.Double(xposBasis, pitchBasis, xMiddle, pitchBasis));
            g2.setStroke(this.verticalStroke);
            g2.draw(new Line2D.Double(xMiddle, pitchBasis, xMiddle, pitch));
            if (pitchBasis != pitch) {
                double yMiddle = (pitchBasis + pitch) / 2.0;
                double yDiff = (pitchBasis - pitch) * 0.05;
                g2.draw(new Line2D.Double(xMiddle - 0.1, yMiddle + yDiff, xMiddle, yMiddle));
                g2.draw(new Line2D.Double(xMiddle + 0.1, yMiddle + yDiff, xMiddle, yMiddle));
            }
            g2.setStroke(this.horizontalStroke);
            g2.draw(new Line2D.Double(xMiddle, pitch, xpos, pitch));
        }
    }

    private void drawNotePopup(Graphics2D g2, DynamicNote popupNote2) {
        double pitch = popupNote2.getPitch() - 2.0;
        double time = popupNote2.getTime() + popupNote2.getOnTime() + 0.1;
        AffineTransform oldTransform = g2.getTransform();
        float ypos = (float)pitch;
        float xpos = (float)time;
        g2.translate(xpos, ypos);
        g2.scale(0.05, -0.05);
        Font font = new Font("Arial", 0, 12);
        g2.setFont(font);
        double maxExtent = 0.0;
        String text1 = NumericOutput.doubleToString(this.popupNote.getPitch(), 1, 2);
        maxExtent = this.extendWidth(g2, maxExtent, text1);
        PrimeFactors primeFactors = popupNote2.getPrimeFactorsTally();
        String text2 = primeFactors.getJustRatio().toString();
        maxExtent = this.extendWidth(g2, maxExtent, text2);
        String text3 = primeFactors.toString();
        maxExtent = this.extendWidth(g2, maxExtent, text3);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(0.0, -65.0, maxExtent + 5.0, 62.0, 1.0, 1.0);
        g2.setColor(new Color(255, 255, 255, 200));
        g2.fill(shape);
        g2.setColor(Color.DARK_GRAY);
        g2.draw(shape);
        g2.setColor(Color.BLACK);
        int tx = 2;
        int ty = -50;
        int tyinc = 20;
        g2.drawString(text1, tx, ty);
        g2.drawString(text2, tx, ty += tyinc);
        g2.drawString(text3, tx, ty += tyinc);
        g2.setTransform(oldTransform);
    }

    private double extendWidth(Graphics2D g2, double maxExtent, String text1) {
        Rectangle2D stringBounds = g2.getFontMetrics().getStringBounds(text1, 0, text1.length(), (Graphics)g2);
        if (stringBounds.getWidth() > maxExtent) {
            maxExtent = stringBounds.getWidth();
        }
        return maxExtent;
    }

    private void drawNoteRatio(Graphics2D g2, DynamicNote note, boolean highlight) {
        double pitch = note.getPitch();
        double time = note.getTime();
        DynamicNote basis = note.getBasis();
        if (basis != null) {
            int numerator = note.getNumerator();
            int denominator = note.getDenominator();
            g2.setColor(highlight ? COLOR_NOTE_RATIO_HIGH : COLOR_NOTE_RATIO);
            float ypos = (float)pitch;
            float xpos = (float)time;
            AffineTransform oldTransform = g2.getTransform();
            g2.translate(xpos, ypos);
            g2.scale(0.05, -0.05);
            Font font = new Font("Arial", 0, 12);
            g2.setFont(font);
            g2.drawString("" + numerator, -8, -4);
            g2.drawString("--", -8, 4);
            g2.drawString("" + denominator, -8, 12);
            g2.setTransform(oldTransform);
        }
    }

    private void drawNoteHead(Graphics2D g2, DynamicNote note, boolean highlight) {
        g2.setColor(highlight ? COLOR_NOTE_HEAD_HIGH : COLOR_NOTE_HEAD);
        g2.fill(this.createNoteShape(note));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragger != null) {
            this.dragger.mouseDragged(e);
        }
    }

    private void markAllDirty() {
        List<ScoreElement> notes = this.dynamicTrack.getElements();
        for (ScoreElement scoreElement : notes) {
            DynamicNote note = (DynamicNote)scoreElement;
            note.markDirty();
        }
    }

    private boolean offsetSelectedNote(double timeOffset, double pitchOffset, DynamicNote noteToMove) {
        Point2D originalTimePitch = this.selectedNoteMap.get(noteToMove);
        return this.moveNote(originalTimePitch.getX() + timeOffset, originalTimePitch.getY() + pitchOffset, noteToMove);
    }

    private boolean moveNote(double moveToTime, double moveToPitch, DynamicNote noteToMove) {
        double previousPitch = noteToMove.getPitch();
        double previousTime = noteToMove.getTime();
        noteToMove.setTime(moveToTime);
        noteToMove.setPitch(moveToPitch);
        noteToMove.quantize();
        double newPitch = noteToMove.getPitch();
        double newTime = noteToMove.getTime();
        boolean changed = true;
        if (Math.abs(previousPitch - newPitch) < 1.0E-4 && Math.abs(previousTime - newTime) < 1.0E-4) {
            changed = false;
        }
        return changed;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.showPastedNotes) {
            Point xy = e.getPoint();
            this.pastedNoteTimePitch = this.transformDtoU.transform(xy, null);
            this.repaint();
        } else {
            if (this.transformDtoU == null) {
                return;
            }
            Point xy = e.getPoint();
            Point2D timePitch = this.transformDtoU.transform(xy, null);
            DynamicNote hitNote = this.pickNote(timePitch);
            if (hitNote != this.popupNote) {
                this.popupNote = hitNote;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.pastedNoteArray != null) {
            this.selectedNoteMap.clear();
            this.showPastedNotes = true;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.pastedNoteArray != null) {
            this.showPastedNotes = false;
            this.repaint();
        }
    }

    private boolean dropPastedNotes(Point2D timePitch) {
        boolean result = false;
        if (this.showPastedNotes && this.pastedNoteArray != null) {
            DynamicNote note;
            double pitchOffset = timePitch.getY() - this.pastedPitchMaximum;
            pitchOffset = Math.round(pitchOffset);
            double timeOffset = timePitch.getX() - this.pastedTimeMinimum;
            DynamicNote[] dynamicNoteArray = this.pastedNoteArray;
            int n = this.pastedNoteArray.length;
            int n2 = 0;
            while (n2 < n) {
                note = dynamicNoteArray[n2];
                note.setPitch(note.getPitch() + pitchOffset);
                note.setTime(note.getTime() + timeOffset);
                if (note.getBasis() == null) {
                    note.quantizePitch();
                } else {
                    note.markDirty();
                }
                note.quantizeTime();
                ++n2;
            }
            dynamicNoteArray = this.pastedNoteArray;
            n = this.pastedNoteArray.length;
            n2 = 0;
            while (n2 < n) {
                note = dynamicNoteArray[n2];
                this.dynamicTrack.add(note);
                this.selectNote(note);
                ++n2;
            }
            this.dynamicTrack.sortByTime();
            result = true;
        }
        this.showPastedNotes = false;
        this.pastedNoteArray = null;
        return result;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        block14: {
            Point2D timePitch;
            Mode alteredMode;
            block13: {
                this.requestFocusInWindow();
                if (this.transformDtoU == null) {
                    return;
                }
                alteredMode = this.getAlteredMode(e);
                Point xy = e.getPoint();
                timePitch = this.transformDtoU.transform(xy, null);
                if (this.dropPastedNotes(timePitch)) {
                    return;
                }
                DynamicNote hitNote = this.pickNote(timePitch);
                if (hitNote == null) break block13;
                boolean alreadySelected = this.isNoteSelected(hitNote);
                if (!alreadySelected && !e.isShiftDown()) {
                    this.selectedNoteMap.clear();
                }
                this.bufferedImage = null;
                switch (alteredMode) {
                    case ADD: {
                        this.dragger = new DraggerAdd(hitNote, timePitch);
                        break;
                    }
                    case SELECT: {
                        this.dragger = timePitch.getX() > hitNote.getTime() + hitNote.getOnTime() * 0.5 ? new DraggerOnTime(hitNote) : new DraggerOld(timePitch);
                        if (!alreadySelected) {
                            this.selectNote(hitNote);
                            break;
                        }
                        break block14;
                    }
                    case RELINK: {
                        this.selectedNoteMap.clear();
                        this.selectNote(hitNote);
                        this.dragger = new DraggerRelink(hitNote);
                    }
                }
                break block14;
            }
            this.selectedNoteMap.clear();
            switch (alteredMode) {
                case SELECT: {
                    this.dragger = new DraggerSelect(e);
                    break;
                }
                case ADD: {
                    this.dragger = new DraggerAdd(timePitch);
                    this.repaint();
                }
            }
        }
        this.repaint();
        this.updateCursor(this.getAlteredMode(e));
    }

    private void selectNote(DynamicNote note) {
        this.selectedNoteMap.put(note, this.createTimePitch(note));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragger != null) {
            this.dragger.mouseReleased(e);
            this.dragger = null;
        }
        this.bufferedImage = null;
        this.updateCursor(this.getAlteredMode(e));
        this.repaint();
    }

    private Mode getAlteredMode(MouseEvent e) {
        if (e.isAltDown()) {
            if (this.mode == Mode.SELECT) {
                return Mode.ADD;
            }
            if (this.mode == Mode.ADD) {
                return Mode.SELECT;
            }
            return this.mode;
        }
        return this.mode;
    }

    public void setDynamicTrack(DynamicTrack dynamicTrack) {
        this.dynamicTrack = dynamicTrack;
        this.reset();
    }

    public DynamicNote[] getSelectedNotes() {
        return this.selectedNoteMap.keySet().toArray(new DynamicNote[0]);
    }

    public void deleteSelectedNotes() {
        for (DynamicNote note : this.selectedNoteMap.keySet()) {
            this.deleteNote(note);
        }
        this.selectedNoteMap.clear();
        this.requestFullRepaint();
    }

    private void deleteNote(DynamicNote note) {
        this.dynamicTrack.remove(note);
        List<ScoreElement> notes = this.dynamicTrack.getElements();
        for (ScoreElement scoreElement : notes) {
            DynamicNote note2 = (DynamicNote)scoreElement;
            if (note2.getBasis() != note) continue;
            note2.setBasis(null);
        }
    }

    private void requestFullRepaint() {
        this.bufferedImage = null;
        this.repaint();
    }

    public void pasteNotes(DynamicNote[] noteArray) {
        this.trimInvalidBasisNotes(noteArray);
        if (noteArray.length > 0) {
            this.pastedNoteArray = noteArray;
            double pitchMax = Double.MIN_VALUE;
            double timeMin = Double.MAX_VALUE;
            DynamicNote[] dynamicNoteArray = noteArray;
            int n = noteArray.length;
            int n2 = 0;
            while (n2 < n) {
                DynamicNote note = dynamicNoteArray[n2];
                if (note.getPitch() > pitchMax) {
                    pitchMax = note.getPitch();
                }
                if (note.getTime() < timeMin) {
                    timeMin = note.getTime();
                }
                ++n2;
            }
            this.pastedPitchMaximum = pitchMax;
            this.pastedTimeMinimum = timeMin;
        }
    }

    private void trimInvalidBasisNotes(DynamicNote[] noteArray) {
        DynamicNote note;
        HashSet<DynamicNote> noteSet = new HashSet<DynamicNote>();
        DynamicNote[] dynamicNoteArray = noteArray;
        int n = noteArray.length;
        int n2 = 0;
        while (n2 < n) {
            note = dynamicNoteArray[n2];
            noteSet.add(note);
            ++n2;
        }
        dynamicNoteArray = noteArray;
        n = noteArray.length;
        n2 = 0;
        while (n2 < n) {
            note = dynamicNoteArray[n2];
            DynamicNote basis = note.getBasis();
            if (basis != null && !noteSet.contains(basis)) {
                note.setBasis(null);
            }
            ++n2;
        }
    }

    @Override
    public double getLeftTime() {
        return this.leftTime;
    }

    @Override
    public double getTimeWidth() {
        return this.timeWidth;
    }

    public void elementPlayed(ScoreElement element) {
        if (element != null) {
            if (element instanceof DynamicNote) {
                this.playingNote = (DynamicNote)element;
            }
        } else {
            this.playingNote = null;
        }
        this.repaint();
    }

    class Dragger {
        Dragger() {
        }

        public boolean doFullPaint() {
            return false;
        }

        public void mouseReleased(MouseEvent e) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void paint2D(Graphics2D g2) {
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    class DraggerAdd
    extends Dragger {
        private DynamicNote addedNote;
        private Point2D clickDownTimePitch;
        private Point2D originalTimePitch;

        public DraggerAdd(DynamicNote basisNote, Point2D timePitch) {
            this.clickDownTimePitch = timePitch;
            this.addedNote = new DynamicNote(basisNote);
            this.addedNote.setTime(basisNote.getTime());
            this.originalTimePitch = DynamicIntonationTrackView.this.createTimePitch(this.addedNote);
            DynamicIntonationTrackView.this.popupNote = this.addedNote;
            DynamicIntonationTrackView.this.selectedNoteMap.clear();
        }

        public DraggerAdd(Point2D timePitch) {
            this.clickDownTimePitch = timePitch;
            this.addedNote = new DynamicNote(EqualTemperedTuning.getMIDIFrequency(timePitch.getY()));
            this.addedNote.setTime(timePitch.getX());
            this.addedNote.quantize();
            this.originalTimePitch = DynamicIntonationTrackView.this.createTimePitch(this.addedNote);
            DynamicIntonationTrackView.this.popupNote = this.addedNote;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.addedNote != null) {
                DynamicIntonationTrackView.this.dynamicTrack.add(this.addedNote);
                DynamicIntonationTrackView.this.selectNote(this.addedNote);
                this.addedNote = null;
            }
        }

        @Override
        public Cursor getCursor() {
            if (this.addedNote == null) {
                return Cursor.getPredefinedCursor(1);
            }
            return Cursor.getPredefinedCursor(12);
        }

        @Override
        public void paint2D(Graphics2D g2) {
            DynamicIntonationTrackView.this.drawNoteStem(g2, this.addedNote, true);
            DynamicIntonationTrackView.this.drawNoteHead(g2, this.addedNote, true);
            DynamicIntonationTrackView.this.drawNoteRatio(g2, this.addedNote, true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point xy = e.getPoint();
            Point2D timePitch = DynamicIntonationTrackView.this.transformDtoU.transform(xy, null);
            double pitch = this.originalTimePitch.getY() + timePitch.getY() - this.clickDownTimePitch.getY();
            double time = this.originalTimePitch.getX() + timePitch.getX() - this.clickDownTimePitch.getX();
            if (DynamicIntonationTrackView.this.moveNote(time, pitch, this.addedNote)) {
                DynamicIntonationTrackView.this.repaint();
            }
        }
    }

    class DraggerOld
    extends Dragger {
        Point2D clickDownTimePitch;

        public DraggerOld(Point2D timePitch) {
            this.clickDownTimePitch = timePitch;
        }

        @Override
        public boolean doFullPaint() {
            return true;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point xy = e.getPoint();
            Point2D timePitch = DynamicIntonationTrackView.this.transformDtoU.transform(xy, null);
            double pitchOffset = timePitch.getY() - this.clickDownTimePitch.getY();
            double timeOffset = timePitch.getX() - this.clickDownTimePitch.getX();
            for (DynamicNote note : DynamicIntonationTrackView.this.selectedNoteMap.keySet()) {
                Point2D originalTimePitch = (Point2D)DynamicIntonationTrackView.this.selectedNoteMap.get(note);
                note.setTime(originalTimePitch.getX() + timeOffset);
                note.setPitch(originalTimePitch.getY() + pitchOffset);
            }
            for (DynamicNote note : DynamicIntonationTrackView.this.selectedNoteMap.keySet()) {
                note.quantize();
            }
            DynamicIntonationTrackView.this.markAllDirty();
            DynamicIntonationTrackView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            for (DynamicNote note : DynamicIntonationTrackView.this.selectedNoteMap.keySet()) {
                DynamicIntonationTrackView.this.selectNote(note);
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(12);
        }
    }

    class DraggerOnTime
    extends Dragger {
        DynamicNote hitNote;

        public DraggerOnTime(DynamicNote hitNote) {
            this.hitNote = hitNote;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point xy = e.getPoint();
            Point2D timePitch = DynamicIntonationTrackView.this.transformDtoU.transform(xy, null);
            double onTime = timePitch.getX() - this.hitNote.getTime();
            if (onTime < 0.125) {
                onTime = 0.125;
            }
            for (DynamicNote note : DynamicIntonationTrackView.this.selectedNoteMap.keySet()) {
                note.setOnTime(onTime);
            }
            DynamicIntonationTrackView.this.repaint();
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }

    class DraggerRelink
    extends Dragger {
        DynamicNote hitNote;
        DynamicNote basisNote;
        Point2D timePitch;

        public DraggerRelink(DynamicNote hitNote) {
            this.hitNote = hitNote;
            hitNote.setBasis(null);
            DynamicIntonationTrackView.this.requestFullRepaint();
        }

        @Override
        public void paint2D(Graphics2D g2) {
            if (this.basisNote != null) {
                DynamicIntonationTrackView.this.drawNoteStem(g2, this.hitNote, true);
            } else if (this.timePitch != null) {
                g2.setStroke(DynamicIntonationTrackView.this.verticalStroke);
                g2.setColor(COLOR_RELINK_RUBBER_BAND);
                g2.draw(new Line2D.Double(this.timePitch.getX(), this.timePitch.getY(), this.hitNote.getTime(), this.hitNote.getPitch()));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point xy = e.getPoint();
            this.timePitch = DynamicIntonationTrackView.this.transformDtoU.transform(xy, null);
            this.basisNote = DynamicIntonationTrackView.this.pickNote(this.timePitch);
            if (this.basisNote != null && this.basisNote != this.hitNote) {
                this.hitNote.setBasis(this.basisNote);
            }
            DynamicIntonationTrackView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.hitNote.quantizePitch();
            DynamicIntonationTrackView.this.selectedNoteMap.clear();
            DynamicIntonationTrackView.this.markAllDirty();
            DynamicIntonationTrackView.this.requestFullRepaint();
        }
    }

    class DraggerSelect
    extends Dragger {
        int startX = 0;
        int startY = 0;

        public DraggerSelect(MouseEvent e) {
            this.startX = e.getX();
            this.startY = e.getY();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int currentX = e.getX();
            int currentY = e.getY();
            int x = currentX;
            int width = this.startX - currentX;
            if (width < 0) {
                width = 0 - width;
                x = this.startX;
            }
            int y = currentY;
            int height = this.startY - currentY;
            if (height < 0) {
                height = 0 - height;
                y = this.startY;
            }
            DynamicIntonationTrackView.this.selectRectangle = new Rectangle(x, y, width, height);
            DynamicIntonationTrackView.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DynamicIntonationTrackView.this.selectRectangle = null;
        }
    }

    public static enum Mode {
        SELECT,
        ADD,
        RELINK;

    }
}

