/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PeakFollower;
import com.jsyn.util.WaveRecorder;
import com.syntona.gui.EasyFileChooser;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;

public class JSynMixer {
    private LineOut lineOut;
    private WaveRecorder recorder;
    private Synthesizer synth;
    private Multiply[] masterGains;
    private File lastRecordingFile;
    private JFrame frame;
    private PeakFollower[] masterPeakFollowers;

    public JSynMixer(Synthesizer synth) {
        this.synth = synth;
        this.lineOut = new LineOut();
        synth.add(this.lineOut);
        this.masterGains = new Multiply[2];
        this.masterPeakFollowers = new PeakFollower[2];
        int i = 0;
        while (i < this.masterPeakFollowers.length) {
            this.masterGains[i] = new Multiply();
            synth.add(this.masterGains[i]);
            this.masterPeakFollowers[i] = new PeakFollower();
            synth.add(this.masterPeakFollowers[i]);
            this.masterGains[i].output.connect(this.masterPeakFollowers[i].input);
            this.masterGains[i].output.connect(0, this.lineOut.input, i);
            this.masterGains[i].inputB.set(1.0);
            this.masterPeakFollowers[i].start();
            ++i;
        }
        this.lineOut.start();
    }

    public WaveRecorder openCapture() throws IOException {
        this.stopCapture();
        this.closeCapture();
        File file = EasyFileChooser.chooseSaveFile("Select a WAV file and folder for the audio capture.", this.frame, this.lastRecordingFile, ".wav");
        if (file != null) {
            this.lastRecordingFile = file;
            this.recorder = new WaveRecorder(this.synth, file, 2, 24);
            System.out.println("Writing to WAV file " + file.getAbsolutePath());
            int i = 0;
            while (i < this.masterGains.length) {
                this.masterGains[i].output.connect(0, this.recorder.getInput(), i);
                ++i;
            }
        }
        return this.recorder;
    }

    public void startCapture() throws IOException {
        this.recorder.start();
    }

    public void stopCapture() throws IOException {
        if (this.recorder != null) {
            this.recorder.stop();
        }
    }

    public void closeCapture() throws IOException {
        if (this.recorder != null) {
            int i = 0;
            while (i < this.masterGains.length) {
                this.recorder.getInput().disconnectAll(i);
                ++i;
            }
            this.recorder.close();
            this.recorder = null;
        }
    }

    public void addTrack(UnitOutputPort output0, UnitOutputPort output1) {
        output0.connect(this.masterGains[0].inputA);
        output1.connect(this.masterGains[1].inputA);
    }

    public double getMasterVolume(int i) {
        return this.masterPeakFollowers[i].output.getValues()[0];
    }
}

