/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class LogWindow
extends JInternalFrame {
    private JTextArea textArea = new JTextArea();
    private static final int MAX_LINES = 1024;

    public LogWindow() {
        super("Syntona Logs", true, true, true, true);
        this.setSize(800, 500);
        this.textArea.setEditable(false);
        this.add(new JScrollPane(this.textArea));
        this.setVisible(true);
        Logger logger = Logger.getLogger("com");
        logger.addHandler(new WindowHandler());
    }

    public void showInfo(String data) {
        int lines = this.textArea.getLineCount();
        if (lines > 1024) {
            int linesToRemove = lines - 1024 - 1;
            try {
                int lengthToRemove = this.textArea.getLineStartOffset(linesToRemove);
                this.textArea.replaceRange("", 0, lengthToRemove);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.textArea.append(data);
        this.validate();
    }

    class WindowHandler
    extends Handler {
        private WindowHandler() {
            LogManager manager = LogManager.getLogManager();
            String className = this.getClass().getName();
            String level = manager.getProperty(String.valueOf(className) + ".level");
            this.setLevel(level != null ? Level.parse(level) : Level.INFO);
            this.setFormatter(new SimpleFormatter());
        }

        @Override
        public synchronized void publish(LogRecord record) {
            String message = null;
            if (!this.isLoggable(record)) {
                return;
            }
            message = this.getFormatter().format(record);
            LogWindow.this.showInfo(message);
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

