/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.view.MessageDialog;
import com.softsynth.wire.LabelledTextField;
import com.softsynth.wire.Module;
import com.softsynth.wire.WireUpdater;

class WireNameUpdater
extends LabelledTextField
implements WireUpdater {
    Module module;

    public WireNameUpdater(Module module, int numColumns) {
        super("Name:", module.getName(), numColumns);
        this.module = module;
    }

    @Override
    public void update() {
    }

    @Override
    public boolean applyEdit() {
        boolean result = false;
        String oldName = this.module.getName();
        String newName = this.getText();
        if (newName.length() == 0) {
            MessageDialog dlg = new MessageDialog("Name cannot be blank! Please choose a new name.", "OK");
            dlg.ask();
            return true;
        }
        if (!oldName.equals(newName) && this.module.getPatch().findModule(newName) != null) {
            MessageDialog dlg = new MessageDialog("Name already used in patch! Please choose a new name.", "OK");
            dlg.ask();
            return true;
        }
        this.module.setName(newName);
        return false;
    }
}

