/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.util.StreamRecorder;
import com.softsynth.jsyn.util.WAVFileWriter;
import com.softsynth.util.TextOutput;
import com.softsynth.wire.InputSynthWireJack;
import com.softsynth.wire.LabelledWireJack;
import com.softsynth.wire.Module;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JButton;

class WAVRecorder
extends Module
implements ActionListener {
    JButton recordButton;
    JButton stopButton;
    InputSynthWireJack inJack;
    LabelledWireJack statusJack;
    StreamRecorder streamRecorder;
    FileOutputStream fileOutStream;
    BufferedOutputStream outStream;
    WAVFileWriter wavWriter;
    RandomAccessFile rfile;
    AddUnit addUnit;
    Color originalStatusColor;
    private RecordFlasherThread flasherThread;

    WAVRecorder() {
    }

    @Override
    public void calculateSize() {
        this.panel.setSize(70, 90);
    }

    @Override
    public void setupJacks() {
        this.addUnit = new AddUnit();
        this.addUnit.start();
        this.inJack = new InputSynthWireJack((Module)this, "input", this.addUnit.inputA);
        this.addJackCanvas(this.inJack);
        this.recordButton = new JButton("Record");
        this.panel.add(this.recordButton);
        this.recordButton.addActionListener(this);
        this.stopButton = new JButton("Stop");
        this.panel.add(this.stopButton);
        this.stopButton.addActionListener(this);
        this.statusJack = new LabelledWireJack(this, "Status");
        this.addJackCanvas(this.statusJack);
        this.originalStatusColor = this.statusJack.getBackground();
    }

    public void startRecording() {
        try {
            String fileName = "recorded.wav";
            File file = new File(fileName);
            this.rfile = new RandomAccessFile(file, "rw");
            TextOutput.println("Recording audio to " + file.getAbsolutePath());
            this.wavWriter = new WAVFileWriter(this.rfile);
            this.outStream = new BufferedOutputStream(this.wavWriter);
            this.wavWriter.writeHeader(1, (int)Synth.getFrameRate());
            this.streamRecorder = new StreamRecorder(this.outStream, 512, 8, 1);
            this.addUnit.output.connect(this.streamRecorder.input);
            this.streamRecorder.start(Synth.getTickCount());
            this.flasherThread = new RecordFlasherThread();
            this.flasherThread.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stopRecording() {
        this.streamRecorder.stop(Synth.getTickCount());
        try {
            this.outStream.flush();
            this.wavWriter.fixSizes();
            this.outStream.close();
            this.rfile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.streamRecorder.input.disconnect();
        this.flasherThread.abort();
        TextOutput.println("Recording stopped.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Record")) {
            System.out.println("Record");
            this.startRecording();
        } else if (cmd.equals("Stop")) {
            System.out.println("Stop");
            this.stopRecording();
        }
    }

    @Override
    String getTagName() {
        return "misc";
    }

    class RecordFlasherThread
    extends Thread {
        boolean go = true;
        boolean state = true;

        RecordFlasherThread() {
        }

        @Override
        public void run() {
            WAVRecorder.this.statusJack.setText("On");
            try {
                while (this.go) {
                    WAVRecorder.this.statusJack.setBackground(this.state ? Color.red : WAVRecorder.this.originalStatusColor);
                    this.state = !this.state;
                    RecordFlasherThread.sleep(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            WAVRecorder.this.statusJack.setText("Off");
            WAVRecorder.this.statusJack.setBackground(WAVRecorder.this.originalStatusColor);
        }

        public void abort() {
            this.go = false;
            this.interrupt();
        }
    }
}

